/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.ServerMessages;

enum CommandLineArgument {
    ADMIN_ONLY{

        @Override
        public String argument() {
            return "--admin-only";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argAdminOnly();
        }
    }
    ,
    PUBLIC_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argPublicBindAddress();
        }
    }
    ,
    LEGACY_PUBLIC_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <value>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argPublicBindAddress();
        }
    }
    ,
    INTERFACE_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<interface>=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argInterfaceBindAddress();
        }
    }
    ,
    SHORT_SERVER_CONFIG{

        @Override
        public String argument() {
            return "-c";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argServerConfig();
        }
    }
    ,
    LEGACY_SHORT_SERVER_CONFIG{

        @Override
        public String argument() {
            return "-c";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <config>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argServerConfig();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public String argument() {
            return "-D";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<name>[=<value>]", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argSystem();
        }
    }
    ,
    SHORT_HELP{

        @Override
        public String argument() {
            return "-h";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argHelp();
        }
    }
    ,
    HELP{

        @Override
        public String argument() {
            return "--help";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argHelp();
        }
    }
    ,
    SHORT_PROPERTIES{

        @Override
        public String argument() {
            return "-P";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argProperties();
        }
    }
    ,
    LEGACY_SHORT_PROPERTIES{

        @Override
        public String argument() {
            return "-P";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <url>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argProperties();
        }
    }
    ,
    PROPERTIES{

        @Override
        public String argument() {
            return "--properties";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argProperties();
        }
    }
    ,
    SECURITY_PROP{

        @Override
        public String argument() {
            return "-S";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<name>[=<value>]", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argSecurityProperty();
        }
    }
    ,
    SERVER_CONFIG{

        @Override
        public String argument() {
            return "--server-config";
        }

        @Override
        public String argumentExample() {
            return String.format("--%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argServerConfig();
        }
    }
    ,
    DEFAULT_MULTICAST_ADDRESS{

        @Override
        public String argument() {
            return "-u";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argDefaultMulticastAddress();
        }
    }
    ,
    LEGACY_DEFAULT_MULTICAST_ADDRESS{

        @Override
        public String argument() {
            return "-u";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <value>", this.argument());
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argDefaultMulticastAddress();
        }
    }
    ,
    LEGACY_SHORT_VERSION{

        @Override
        public String argument() {
            return "-V";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argVersion();
        }
    }
    ,
    SHORT_VERSION{

        @Override
        public String argument() {
            return "-v";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argVersion();
        }
    }
    ,
    VERSION{

        @Override
        public String argument() {
            return "--version";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ServerMessages.MESSAGES.argVersion();
        }
    };

    private static String USAGE;
    static final String NEW_LINE;

    public abstract String argument();

    public abstract String argumentExample();

    public abstract String instructions();

    public String toString() {
        ArrayList<String> instructions = new ArrayList<String>();
        CommandLineArgument.segmentInstructions(this.instructions(), instructions);
        StringBuilder sb = new StringBuilder(String.format("    %-35s %s", this.argumentExample(), instructions.get(0)));
        for (int i = 1; i < instructions.size(); ++i) {
            sb.append(NEW_LINE);
            sb.append(String.format("%-40s%s", " ", instructions.get(i)));
        }
        sb.append(NEW_LINE);
        return sb.toString();
    }

    private static void segmentInstructions(String instructions, List<String> segments) {
        if (instructions.length() <= 40) {
            segments.add(instructions);
        } else {
            String testFragment = instructions.substring(0, 40);
            int lastSpace = testFragment.lastIndexOf(32);
            if (lastSpace < 0) {
                lastSpace = 39;
            }
            segments.add(instructions.substring(0, lastSpace + 1));
            CommandLineArgument.segmentInstructions(instructions.substring(lastSpace + 1), segments);
        }
    }

    public static void printUsage(PrintStream out) {
        out.print(CommandLineArgument.usage());
    }

    public static String usage() {
        if (USAGE == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ServerMessages.MESSAGES.argUsage()).append(NEW_LINE);
            for (CommandLineArgument arg : CommandLineArgument.values()) {
                sb.append(arg.toString()).append(NEW_LINE);
            }
            USAGE = sb.toString();
        }
        return USAGE;
    }

    static {
        NEW_LINE = String.format("%n", new Object[0]);
    }
}

