/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageBundle(projectCode="JBAS")
public interface ServerMessages {
    public static final ServerMessages MESSAGES = (ServerMessages)Messages.getBundle(ServerMessages.class);

    @Message(id=0, value="Usage: ./standalone.sh [args...]%nwhere args include:")
    public String argUsage();

    @Message(id=0, value="Name of the server configuration file to use (default is \"standalone.xml\")")
    public String argServerConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a security property")
    public String argSecurityProperty();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Set the server's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start other runtime services or accept end user requests.")
    public String argAdminOnly();

    @Message(id=15800, value="Value expected for option %s")
    public String valueExpectedForCommandLineOption(String var1);

    @Message(id=15801, value="Invalid option '%s'")
    public String invalidCommandLineOption(String var1);

    @Message(id=15802, value="Malformed URL '%s' provided for option '%s'")
    public String malformedCommandLineURL(String var1, String var2);

    @Message(id=15803, value="Unable to load properties from URL '%s'")
    public String unableToLoadProperties(URL var1);

    @Message(id=15804, value="Error initializing vault --  %s")
    public RuntimeException cannotCreateVault(@Param VaultReaderException var1, VaultReaderException var2);

    @Message(id=15805, value="Failed to connect to the host-controller")
    public StartException failedToConnectToHC(@Param Exception var1);

    @Message(id=15806, value="Connection request to the host-controller was cancelled")
    public StartException cancelledHCConnect();

    @Message(id=15807, value="hostControllerName must be null if the server is not in a managed domain")
    public IllegalArgumentException hostControllerNameNonNullInStandalone();

    @Message(id=15808, value="hostControllerName may not be null if the server is in a managed domain")
    public IllegalArgumentException hostControllerNameNullInDomain();

    @Message(id=15809, value="An IP address cannot be resolved using the given interface selection criteria. Failure was -- %s")
    public OperationFailedException cannotResolveInterface(Exception var1, @Param Exception var2);

    @Message(id=15810, value="failed to resolve interface %s")
    public StartException failedToResolveInterface(String var1);

    @Message(id=15811, value="Failed to start the http-interface service")
    public StartException failedToStartHttpManagementService(@Param Exception var1);

    @Message(id=15812, value="No deployment content with hash %s is available in the deployment content repository.")
    public OperationFailedException noSuchDeploymentContent(String var1);

    @Message(id=15813, value="No deployment with name %s found")
    public OperationFailedException noSuchDeployment(String var1);

    @Message(id=15814, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public OperationFailedException cannotReplaceDeployment(String var1, String var2, String var3, String var4, String var5);

    @Message(id=15815, value="Deployment %s is already started")
    public OperationFailedException deploymentAlreadyStarted(String var1);

    @Message(id=15816, value="Missing configuration value for: %s")
    public IllegalStateException missingHomeDirConfiguration(String var1);

    @Message(id=15817, value="\n        %s is missing: %s")
    public String missingDependencies(ServiceName var1, String var2);

    @Message(id=15818, value="%s is required")
    public OperationFailedException attributeIsRequired(String var1);

    @Message(id=15819, value="%s is not allowed when %s are present")
    public OperationFailedException attributeNotAllowedWhenAlternativeIsPresent(String var1, List<String> var2);

    @Message(id=15820, value="%s is invalid")
    public OperationFailedException attributeIsInvalid(String var1);

    @Message(id=15821, value="Caught IOException reading uploaded deployment content")
    public OperationFailedException caughtIOExceptionUploadingContent(@Cause IOException var1);

    @Message(id=15822, value="Null stream at index [%d]")
    public OperationFailedException nullStreamAttachment(int var1);

    @Message(id=15823, value="'%s' is not a valid URL")
    public OperationFailedException invalidDeploymentURL(String var1, @Cause MalformedURLException var2);

    @Message(id=15824, value="Error obtaining input stream from URL '%s'")
    public OperationFailedException problemOpeningStreamFromDeploymentURL(String var1, @Cause IOException var2);

    @Message(id=15826, value="ServiceModuleLoader already started")
    public IllegalStateException serviceModuleLoaderAlreadyStarted();

    @Message(id=15827, value="ServiceModuleLoader already stopped")
    public IllegalStateException serviceModuleLoaderAlreadyStopped();

    @Message(id=15828, value="'%s' cannot be loaded from a ServiceModuleLoader as its name does not start with '%s'")
    public IllegalArgumentException missingModulePrefix(ModuleIdentifier var1, String var2);

    @Message(id=15829, value="Failed to read '%s'")
    public DeploymentUnitProcessingException failedToReadVirtualFile(VirtualFile var1, @Cause IOException var2);

    @Message(id=15830, value="Deployment root is required")
    public IllegalArgumentException deploymentRootRequired();

    @Message(id=15831, value="Sub-deployments require a parent deployment unit")
    public IllegalArgumentException subdeploymentsRequireParent();

    @Message(id=15832, value="No Module Identifier attached to deployment '%s'")
    public DeploymentUnitProcessingException noModuleIdentifier(String var1);

    @Message(id=15834, value="Failed to create VFSResourceLoader for root [%s]")
    public DeploymentUnitProcessingException failedToCreateVFSResourceLoader(String var1, @Cause IOException var2);

    @Message(id=15835, value="Failed to get file from remote repository")
    public RuntimeException failedToGetFileFromRemoteRepository(@Cause Throwable var1);

    @Message(id=15836, value="Unable to create local directory: %s")
    public IOException cannotCreateLocalDirectory(File var1);

    @Message(id=15837, value="Did not read the entire file. Missing: %d")
    public IOException didNotReadEntireFile(long var1);

    @Message(id=15838, value="No value was provided for argument %s%n")
    public String noArgValue(String var1);

    @Message(id=15839, value="Could not find the file repository connection to the host controller.")
    public IllegalStateException couldNotFindHcFileRepositoryConnection();

    @Message(id=15840, value="Only 'hash' is allowed for deployment addition for a domain mode server: %s")
    public IllegalStateException onlyHashAllowedForDeploymentAddInDomainServer(ModelNode var1);

    @Message(id=15841, value="Only 'hash' is allowed for deployment full replacement for a domain mode server: %s")
    public IllegalStateException onlyHashAllowedForDeploymentFullReplaceInDomainServer(ModelNode var1);

    @Message(id=15842, value="Unknown mount type %s")
    public IllegalArgumentException unknownMountType(MountType var1);

    @Message(id=15843, value="Failed to create temp file provider")
    public StartException failedCreatingTempProvider();

    @Message(id=15844, value="%s cannot be defined when either %s or %s is also defined")
    public OperationFailedException illegalCombinationOfHttpManagementInterfaceConfigurations(String var1, String var2, String var3);

    @Message(id=15845, value="System property %s cannot be set via the xml configuration file or from a management client; it's value must be known at initial process start so it can only set from the commmand line")
    public OperationFailedException systemPropertyNotManageable(String var1);

    @Message(id=15846, value="System property %s cannot be set after the server name has been set via the xml configuration file or from a management client")
    public OperationFailedException systemPropertyCannotOverrideServerName(String var1);

    @Message(id=15847, value="Unable to initialise a basic SSLContext '%s'")
    public IOException unableToInitialiseSSLContext(String var1);
}

