/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.AbstractBindingWriteHandler;
import org.jboss.dmr.ModelNode;

public class BindingMulticastAddressHandler
extends AbstractBindingWriteHandler {
    public static final BindingMulticastAddressHandler INSTANCE = new BindingMulticastAddressHandler();

    private BindingMulticastAddressHandler() {
        super((ParameterValidator)new InetAddressValidator(true, true), (ParameterValidator)new InetAddressValidator(true, false));
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    @Override
    void handleRuntimeChange(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) throws OperationFailedException {
        InetAddress address;
        if (attributeValue.isDefined()) {
            try {
                address = InetAddress.getByName(attributeValue.asString());
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(new ModelNode().set("failed to get multi-cast address for " + attributeValue));
            }
        } else {
            address = null;
        }
        binding.setMulticastAddress(address);
    }

    @Override
    void handleRuntimeRollback(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) {
        InetAddress address;
        if (attributeValue.isDefined()) {
            try {
                address = InetAddress.getByName(attributeValue.asString());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Failed to get multi-cast address for " + attributeValue.asString());
            }
        } else {
            address = null;
        }
        binding.setMulticastAddress(address);
    }
}

