/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.transaction.TransactionMode;

public class InvocationBatchingConfigurationBuilder
extends AbstractConfigurationChildBuilder<InvocationBatchingConfiguration> {
    boolean enabled = false;

    InvocationBatchingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public InvocationBatchingConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public InvocationBatchingConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    @Override
    void validate() {
        if (this.enabled && this.getBuilder().transaction().transactionMode != null && this.getBuilder().transaction().transactionMode.equals((Object)TransactionMode.NON_TRANSACTIONAL)) {
            throw new IllegalStateException("Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL");
        }
    }

    @Override
    InvocationBatchingConfiguration create() {
        return new InvocationBatchingConfiguration(this.enabled);
    }

    public InvocationBatchingConfigurationBuilder read(InvocationBatchingConfiguration template) {
        this.enabled = template.enabled();
        return this;
    }
}

