/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.configuration.cache.AbstractLoaderConfiguration;

public class LoadersConfiguration {
    private final boolean passivation;
    private final boolean preload;
    private final boolean shared;
    private final List<AbstractLoaderConfiguration> cacheLoaders;

    LoadersConfiguration(boolean passivation, boolean preload, boolean shared, List<AbstractLoaderConfiguration> cacheLoaders) {
        this.passivation = passivation;
        this.preload = preload;
        this.shared = shared;
        this.cacheLoaders = cacheLoaders;
    }

    public boolean passivation() {
        return this.passivation;
    }

    public boolean preload() {
        return this.preload;
    }

    public boolean shared() {
        return this.shared;
    }

    public List<AbstractLoaderConfiguration> cacheLoaders() {
        return this.cacheLoaders;
    }

    public Boolean fetchPersistentState() {
        for (AbstractLoaderConfiguration c : this.cacheLoaders) {
            if (!c.fetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public boolean usingCacheLoaders() {
        return !this.cacheLoaders.isEmpty();
    }

    public boolean usingAsyncStore() {
        for (AbstractLoaderConfiguration loaderConfig : this.cacheLoaders) {
            if (!loaderConfig.async().enabled()) continue;
            return true;
        }
        return false;
    }

    public boolean usingChainingCacheLoader() {
        return !this.passivation() && this.cacheLoaders.size() > 1;
    }
}

