/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.remoting.transport.Address;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;

@Scope(value=Scopes.NAMED_CACHE)
public interface StateTransferManager {
    @ManagedAttribute(description="If true, the node has successfully joined the grid and is considered to hold state.  If false, the join process is still in progress.")
    @Metric(displayName="Is join completed?", dataType=DataType.TRAIT)
    public boolean isJoinComplete();

    public void waitForJoinToComplete() throws InterruptedException;

    public boolean hasJoinStarted();

    public void waitForJoinToStart() throws InterruptedException;

    @ManagedAttribute(description="Checks whether there is a pending state transfer in the cluster.")
    @Metric(displayName="Is state transfer in progress?", dataType=DataType.TRAIT)
    public boolean isStateTransferInProgress();

    public void waitForStateTransferToComplete() throws InterruptedException;

    public void applyState(Collection<InternalCacheEntry> var1, Address var2, int var3) throws InterruptedException;

    public boolean isLocationInDoubt(Object var1);
}

