/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SysPropertyActions {
    public static String getProperty(String name, String defaultValue) {
        String prop = System.getSecurityManager() == null ? SysProps.NON_PRIVILEDGED.getProperty(name, defaultValue) : SysProps.PRIVILEDGED.getProperty(name, defaultValue);
        return prop;
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }
        };
        public static final SysProps PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);
    }
}

