/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ejb.FinderException;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.ejbql.SelectFunction;
import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryManager;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.QLCompiler;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCDynamicQLQuery
extends JDBCAbstractQueryCommand {
    private final Catalog catalog;
    private final JDBCDynamicQLQueryMetaData metadata;

    public JDBCDynamicQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q) {
        super(manager, q);
        this.catalog = manager.getCatalog();
        this.metadata = (JDBCDynamicQLQueryMetaData)q;
    }

    @Override
    public Collection execute(Method finderMethod, Object[] args, CmpEntityBeanContext ctx, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        List leftJoinCMRList;
        boolean[] mask;
        Class[] parameterTypes;
        String dynamicQL = (String)args[0];
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("DYNAMIC-QL: " + dynamicQL));
        }
        QLCompiler compiler = null;
        try {
            compiler = JDBCQueryManager.getInstance(this.metadata.getQLCompilerClass(), this.catalog);
        }
        catch (Throwable e) {
            throw new FinderException(e.getMessage());
        }
        Object[] parameters = (Object[])args[1];
        if (parameters == null) {
            parameterTypes = new Class[]{};
        } else {
            parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    throw new FinderException("Parameter[" + i + "] is null");
                }
                parameterTypes[i] = parameters[i].getClass();
            }
        }
        try {
            compiler.compileJBossQL(dynamicQL, finderMethod.getReturnType(), parameterTypes, this.metadata);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FinderException("Error compiling ejbql: " + t);
        }
        int offset = JDBCDynamicQLQuery.toInt(parameters, compiler.getOffsetParam(), compiler.getOffsetValue());
        int limit = JDBCDynamicQLQuery.toInt(parameters, compiler.getLimitParam(), compiler.getLimitValue());
        JDBCEntityBridge selectEntity = null;
        JDBCCMPFieldBridge selectField = null;
        SelectFunction selectFunction = null;
        if (compiler.isSelectEntity()) {
            selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
        } else if (compiler.isSelectField()) {
            selectField = (JDBCCMPFieldBridge)compiler.getSelectField();
        } else {
            selectFunction = compiler.getSelectFunction();
        }
        JDBCReadAheadMetaData readahead = this.metadata.getReadAhead();
        if (selectEntity != null && readahead.isOnFind()) {
            mask = selectEntity.getLoadGroupMask(readahead.getEagerLoadGroup());
            boolean modifiedMask = false;
            leftJoinCMRList = compiler.getLeftJoinCMRList();
            if (compiler.isSelectDistinct()) {
                JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
                for (int i = 0; i < tableFields.length; ++i) {
                    if (!mask[i] || tableFields[i].getJDBCType().isSearchable()) continue;
                    if (!modifiedMask) {
                        boolean[] original = mask;
                        mask = new boolean[original.length];
                        System.arraycopy(original, 0, mask, 0, mask.length);
                        modifiedMask = true;
                    }
                    mask[i] = false;
                }
            }
        } else {
            mask = null;
            leftJoinCMRList = Collections.EMPTY_LIST;
        }
        this.setParameterList(compiler.getInputParameters());
        final CmpEntityBeanComponent component = ((JDBCStoreManager)compiler.getStoreManager()).getComponent();
        JDBCQueryCommand.EntityProxyFactory factoryToUse = new JDBCQueryCommand.EntityProxyFactory(){

            @Override
            public Object getEntityObject(Object primaryKey) {
                return JDBCDynamicQLQuery.this.metadata.isResultTypeMappingLocal() && component.getLocalHomeClass() != null ? component.getEJBLocalObject(primaryKey) : component.getEJBObject(primaryKey);
            }
        };
        return this.execute(compiler.getSQL(), parameters, offset, limit, selectEntity, selectField, selectFunction, (JDBCStoreManager)compiler.getStoreManager(), mask, compiler.getInputParameters(), leftJoinCMRList, this.metadata, factoryToUse, this.log);
    }
}

