/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2.bridge;

import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.bridge.SelectorBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.QueryCommand;
import org.jboss.as.cmp.jdbc2.schema.Schema;

public class EJBSelectBridge
implements SelectorBridge {
    private static final byte SINGLE = 0;
    private static final byte COLLECTION = 2;
    private final JDBCQueryMetaData metadata;
    private final QueryCommand command;
    private final byte returnType;
    private final Schema schema;
    private boolean syncBeforeSelect;
    private TransactionManager tm;

    public EJBSelectBridge(JDBCStoreManager2 manager, CmpEntityBeanComponent component, Schema schema, JDBCQueryMetaData metadata, QueryCommand command) {
        this.schema = schema;
        this.metadata = metadata;
        this.command = command;
        Class<?> type = metadata.getMethod().getReturnType();
        this.returnType = Collection.class.isAssignableFrom(type) ? (byte)2 : (byte)0;
        this.tm = component.getTransactionManager();
        this.syncBeforeSelect = !manager.getCmpConfig().isSyncOnCommitOnly();
    }

    @Override
    public Object invoke(CmpEntityBeanContext instance, Method method, Object[] args) throws Exception {
        Transaction tx;
        Transaction transaction = tx = instance != null ? instance.getTransaction() : this.tm.getTransaction();
        if (this.syncBeforeSelect) {
            instance.getComponent().synchronizeEntitiesWithinTransaction(tx);
        }
        return this.execute(instance, args);
    }

    @Override
    public String getSelectorName() {
        return this.metadata.getMethod().getName();
    }

    @Override
    public Method getMethod() {
        return this.metadata.getMethod();
    }

    @Override
    public Object execute(CmpEntityBeanContext ctx, Object[] args) throws FinderException {
        Object result;
        JDBCStoreManager2 manager = this.command.getStoreManager();
        final CmpEntityBeanComponent selectedComponent = manager.getComponent();
        JDBCQueryCommand.EntityProxyFactory factory = new JDBCQueryCommand.EntityProxyFactory(){

            @Override
            public Object getEntityObject(Object primaryKey) {
                return EJBSelectBridge.this.metadata.isResultTypeMappingLocal() && selectedComponent.getLocalHomeClass() != null ? selectedComponent.getEJBLocalObject(primaryKey) : selectedComponent.getEJBObject(primaryKey);
            }
        };
        switch (this.returnType) {
            case 0: {
                result = this.command.fetchOne(this.schema, args, factory);
                if (result != null || !this.getMethod().getReturnType().isPrimitive()) break;
                throw new FinderException("Cannot return null as a value of primitive type " + this.getMethod().getReturnType().getName());
            }
            case 2: {
                result = this.command.fetchCollection(this.schema, args, factory);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected return type: " + this.returnType);
            }
        }
        return result;
    }
}

