/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.modcluster.container.Connector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaConnector
implements Connector {
    protected final org.apache.catalina.connector.Connector connector;

    public CatalinaConnector(org.apache.catalina.connector.Connector connector) {
        this.connector = connector;
    }

    public InetAddress getAddress() {
        Object value = IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"address");
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setAddress(InetAddress address) {
        IntrospectionUtils.setProperty((Object)this.connector.getProtocolHandler(), (String)"address", (String)address.getHostAddress());
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public Connector.Type getType() {
        if (CatalinaConnector.isAJP(this.connector)) {
            return Connector.Type.AJP;
        }
        ProtocolHandler handler = this.connector.getProtocolHandler();
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"secure")) ? Connector.Type.HTTPS : Connector.Type.HTTP;
    }

    public boolean isReverse() {
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"reverseConnection"));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaConnector)) {
            return false;
        }
        CatalinaConnector connector = (CatalinaConnector)object;
        return this.connector == connector.connector;
    }

    public int hashCode() {
        return this.connector.hashCode();
    }

    public String toString() {
        InetAddress address = this.getAddress();
        return String.format("%s://%s:%d", this.getType(), address != null ? address.getHostAddress() : "<undefined>", this.connector.getPort());
    }

    public static boolean isAJP(org.apache.catalina.connector.Connector connector) {
        String protocol = connector.getProtocol();
        return protocol.startsWith("AJP") || protocol.startsWith("org.apache.coyote.ajp");
    }

    public boolean isAvailable() {
        return false;
    }

    public int getMaxThreads() {
        Integer result = (Integer)IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"maxThreads");
        return result != null ? result : 0;
    }

    public int getBusyThreads() {
        Object endpoint = this.getEndpoint();
        return endpoint != null ? (Integer)IntrospectionUtils.getProperty((Object)endpoint, (String)"currentThreadsBusy") : 0;
    }

    protected Object getEndpoint() {
        return this.getProtocolHandlerProperty("endpoint");
    }

    protected Object getProtocolHandlerProperty(String property) {
        Field field = this.findField(this.connector.getProtocolHandler().getClass(), property);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(this.connector.getProtocolHandler());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    Field findField(Class<?> targetClass, String name) {
        if (targetClass == null || Object.class.equals(targetClass)) {
            return null;
        }
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return this.findField(targetClass.getSuperclass(), name);
    }

    public long getBytesSent() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? this.getRequestGroupInfo().getBytesSent() : 0L;
    }

    public long getBytesReceived() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? this.getRequestGroupInfo().getBytesReceived() : 0L;
    }

    public long getRequestCount() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? (long)this.getRequestGroupInfo().getRequestCount() : 0L;
    }

    protected Object getConnectionHandler() {
        return this.getProtocolHandlerProperty("cHandler");
    }

    protected RequestGroupInfo getRequestGroupInfo() {
        Object connectionHandler = this.getConnectionHandler();
        if (connectionHandler == null) {
            return null;
        }
        return this.getRequestGroupInfo(connectionHandler);
    }

    protected RequestGroupInfo getRequestGroupInfo(Object connectionHandler) {
        Field field = this.findField(connectionHandler.getClass(), "global");
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (RequestGroupInfo)field.get(connectionHandler);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

