/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractBeanDiscoveryEvent;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.ExternalAnnotatedType;
import org.jboss.weld.literal.InterceptorBindingTypeLiteral;
import org.jboss.weld.literal.NormalScopeLiteral;
import org.jboss.weld.literal.QualifierLiteral;
import org.jboss.weld.literal.ScopeLiteral;
import org.jboss.weld.literal.StereotypeLiteral;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeforeBeanDiscoveryImpl
extends AbstractBeanDiscoveryEvent
implements BeforeBeanDiscovery {
    public static void fire(BeanManagerImpl beanManager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts) {
        new BeforeBeanDiscoveryImpl(beanManager, deployment, beanDeployments, contexts).fire(beanDeployments);
    }

    protected BeforeBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)BeforeBeanDiscovery.class), beanDeployments, deployment, contexts);
    }

    public void addQualifier(Class<? extends Annotation> bindingType) {
        this.getTypeStore().add(bindingType, (Annotation)QualifierLiteral.INSTANCE);
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
    }

    public void addInterceptorBinding(Class<? extends Annotation> bindingType, Annotation ... bindingTypeDef) {
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(bindingType, (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
        for (Annotation a : bindingTypeDef) {
            typeStore.add(bindingType, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
    }

    public void addScope(Class<? extends Annotation> scopeType, boolean normal, boolean passivating) {
        if (normal) {
            this.getTypeStore().add(scopeType, (Annotation)((Object)new NormalScopeLiteral(passivating)));
        } else {
            if (passivating) {
                throw new DefinitionException(BootstrapMessage.PASSIVATING_NON_NORMAL_SCOPE_ILLEGAL, scopeType);
            }
            this.getTypeStore().add(scopeType, (Annotation)ScopeLiteral.INSTANCE);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(scopeType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(scopeType);
    }

    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(stereotype, (Annotation)StereotypeLiteral.INSTANCE);
        for (Annotation a : stereotypeDef) {
            typeStore.add(stereotype, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(stereotype);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(stereotype);
    }

    public void addAnnotatedType(AnnotatedType<?> type) {
        this.getOrCreateBeanDeployment(type.getJavaClass()).getBeanDeployer().addClass(ExternalAnnotatedType.of(type));
    }
}

