/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerkManager;

public class UDDIClientContainer {
    private static Log log = LogFactory.getLog(UDDIClientContainer.class);
    private static Map<String, UDDIClerkManager> managers = new HashMap<String, UDDIClerkManager>();

    public static UDDIClerkManager getUDDIClerkManager(String managerName) throws ConfigurationException {
        if (managerName != null) {
            if (managers.containsKey(managerName)) {
                return managers.get(managerName);
            }
            throw new ConfigurationException("No manager by name " + managerName + " was found. " + " Please check your client uddi.xml files, and make sure this manager was started");
        }
        if (managers.size() == 1 && managerName == null) {
            log.warn((Object)"Deprecated, please specify a manager name");
            return managers.values().iterator().next();
        }
        log.warn((Object)"Deprecated, please specify a manager name");
        UDDIClerkManager manager = new UDDIClerkManager(null);
        UDDIClientContainer.addClerkManager(manager);
        manager.start();
        return manager;
    }

    public static boolean addClerkManager(UDDIClerkManager manager) {
        if (!managers.containsKey(manager.getClientConfig().getManagerName())) {
            managers.put(manager.getClientConfig().getManagerName(), manager);
            return true;
        }
        return false;
    }

    public static void removeClerkManager(String managerName) throws ConfigurationException {
        if (managers.containsKey(managerName)) {
            managers.remove(managerName);
        } else if (managers.size() == 1 && managerName == null) {
            String name = managers.keySet().iterator().next();
            log.info((Object)("Removing " + name + " from UDDIClient."));
            managers.remove(name);
        } else {
            throw new ConfigurationException("Could not remove UDDIClerkManager for name " + managerName);
        }
    }
}

