/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.io.FileNotFoundException;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.file.AbstractFileHandlerService;
import org.jboss.as.logging.handlers.file.HandlerFileService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

class FileHandlers {
    FileHandlers() {
    }

    static void addFile(OperationContext context, ServiceBuilder<Handler> serviceBuilder, AbstractFileHandlerService service, ModelNode file, String name) throws OperationFailedException {
        if (file.isDefined()) {
            ModelNode path = CommonAttributes.PATH.resolveModelAttribute(context, file);
            ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, file);
            ServiceName serviceName = LogServices.handlerFileName(name);
            ServiceTarget serviceTarget = context.getServiceTarget();
            HandlerFileService fileService = new HandlerFileService(path.asString());
            ServiceBuilder fileBuilder = serviceTarget.addService(serviceName, (Service)fileService);
            if (relativeTo.isDefined()) {
                fileBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo.asString()), String.class, fileService.getRelativeToInjector());
            }
            fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
        }
    }

    static boolean changeFile(OperationContext context, ModelNode oldFile, ModelNode newFile, String name) throws OperationFailedException {
        boolean requiresRestart = false;
        if (newFile.isDefined()) {
            ModelNode path = CommonAttributes.PATH.resolveModelAttribute(context, newFile);
            ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, newFile);
            ModelNode currentRelativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, oldFile);
            if (relativeTo.isDefined() && !currentRelativeTo.equals(relativeTo) && !AbstractPathService.isAbsoluteUnixOrWindowsPath((String)path.asString())) {
                requiresRestart = true;
            } else {
                ServiceName serviceName = LogServices.handlerFileName(name);
                ServiceRegistry registry = context.getServiceRegistry(true);
                ServiceController fileController = registry.getService(serviceName);
                if (fileController == null) {
                    throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.serviceNotFound(serviceName)));
                }
                HandlerFileService fileService = (HandlerFileService)fileController.getService();
                fileService.setPath(path.asString());
                ServiceController handlerController = registry.getService(LogServices.handlerName(name));
                AbstractFileHandlerService handlerService = (AbstractFileHandlerService)handlerController.getService();
                String fileName = fileService.getValue();
                try {
                    handlerService.setFile(fileName);
                }
                catch (FileNotFoundException e) {
                    throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.fileNotFound(fileName)));
                }
            }
        }
        return requiresRestart;
    }

    static void revertFileChange(OperationContext context, ModelNode file, String name) throws OperationFailedException {
        if (file.isDefined()) {
            ModelNode path = CommonAttributes.PATH.resolveModelAttribute(context, file);
            ServiceName serviceName = LogServices.handlerFileName(name);
            ServiceRegistry registry = context.getServiceRegistry(true);
            ServiceController fileController = registry.getService(serviceName);
            if (fileController == null) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.serviceNotFound(serviceName)));
            }
            HandlerFileService fileService = (HandlerFileService)fileController.getService();
            fileService.setPath(path.asString());
            ServiceController handlerController = registry.getService(LogServices.handlerName(name));
            AbstractFileHandlerService handlerService = (AbstractFileHandlerService)handlerController.getService();
            String fileName = fileService.getValue();
            try {
                handlerService.setFile(fileName);
            }
            catch (FileNotFoundException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.fileNotFound(fileName)));
            }
        }
    }
}

