/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.osgi.framework.internal.EntriesProvider;

final class ModuleEntriesProvider
implements EntriesProvider {
    static final Logger log = Logger.getLogger(ModuleEntriesProvider.class);
    private final Module module;

    ModuleEntriesProvider(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        this.module = module;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        Enumeration urls = this.module.getExportedResources(path);
        if (urls == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        while (urls.hasMoreElements()) {
            result.add(((URL)urls.nextElement()).getPath());
        }
        return result.elements();
    }

    @Override
    public URL getEntry(String path) {
        return this.module.getExportedResource(path);
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        log.warnf("[JBOSGI-408] Bundle entry related functionality for plain modules", new Object[0]);
        return null;
    }
}

