/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.registry.FileBasedSTSOperations;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

public class FileBasedTokenRegistry
extends FileBasedSTSOperations
implements SecurityTokenRegistry {
    protected static final String FILE_NAME = "token.registry";
    protected File registryFile;
    protected Map<String, TokenHolder> holders = new HashMap<String, TokenHolder>();

    public FileBasedTokenRegistry() {
        this(FILE_NAME);
    }

    public FileBasedTokenRegistry(String fileName) {
        if (this.directory == null) {
            throw new IllegalStateException("PL00092: Null Value:directory");
        }
        this.registryFile = this.create(fileName);
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToken(String tokenID, Object token) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        if (!(token instanceof Serializable)) {
            throw new IOException("PL00093: Not Serializable:Token");
        }
        this.holders.put(tokenID, new TokenHolder(tokenID, token));
        this.flush();
    }

    public void removeToken(String tokenID) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.holders.remove(tokenID);
        this.flush();
    }

    public Object getToken(String tokenID) {
        TokenHolder holder;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        if ((holder = this.holders.get(tokenID)) != null) {
            return holder.token;
        }
        return null;
    }

    protected synchronized void flush() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.registryFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.holders);
        oos.close();
    }

    protected synchronized void read() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        FileInputStream fis = new FileInputStream(this.registryFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            try {
                this.holders = (Map)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        finally {
            ois.close();
        }
    }

    protected static class TokenHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String id;
        Object token;

        public TokenHolder(String id, Object token) {
            this.id = id;
            this.token = token;
        }

        public String getId() {
            return this.id;
        }

        public Object getToken() {
            return this.token;
        }
    }
}

