/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.roles;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRoleValidator
implements IRoleValidator {
    private static Logger log = Logger.getLogger(DefaultRoleValidator.class);
    private boolean trace = log.isTraceEnabled();
    private Set<String> roleNames = new HashSet<String>();

    @Override
    public void intialize(Map<String, String> options) {
        String csv = options.get("ROLES");
        if (csv == null) {
            if (this.trace) {
                log.trace((Object)"There is no ROLES config");
            }
        } else {
            StringTokenizer st = new StringTokenizer(csv, ",");
            while (st != null && st.hasMoreTokens()) {
                this.roleNames.add(st.nextToken());
            }
        }
    }

    @Override
    public boolean userInRole(Principal userPrincipal, List<String> roles) {
        for (String roleName : roles) {
            if (!this.roleNames.contains(roleName)) continue;
            return true;
        }
        return false;
    }
}

