/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Date;
import org.jacorb.config.Configuration;
import org.jacorb.notification.engine.DefaultTaskExecutor;
import org.jacorb.notification.engine.DefaultTaskProcessorMBean;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.util.DisposableManager;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;
import org.slf4j.Logger;

public class DefaultTaskProcessor
implements TaskProcessor,
Disposable,
JMXManageable,
DefaultTaskProcessorMBean {
    final Logger logger_;
    private TaskExecutor pullTaskExecutor_;
    private ScheduledExecutorService clockDaemon_;
    private final TaskFactory taskFactory_;
    private final DisposableManager disposables_ = new DisposableManager();
    private int pullWorkerPoolSize_;
    private int filterWorkerPoolSize_;

    public DefaultTaskProcessor(Configuration configuration, TaskFactory taskFactory) {
        this.clockDaemon_ = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("ClockDaemonThread");
                return thread;
            }
        });
        this.logger_ = configuration.getLogger(this.getClass().getName());
        this.logger_.info("create TaskProcessor");
        this.pullWorkerPoolSize_ = configuration.getAttributeAsInteger("jacorb.notification.proxyconsumer.thread_pool_size", 2);
        this.pullTaskExecutor_ = new DefaultTaskExecutor("PullThread", this.pullWorkerPoolSize_, true);
        this.filterWorkerPoolSize_ = configuration.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.taskFactory_ = taskFactory;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutdown();
        this.pullTaskExecutor_.dispose();
        this.disposables_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message message) {
        if (message.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (message.getStopTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(message);
                message.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(message);
        }
        if (message.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(message);
        }
        if (message.hasStartTime() && message.getStartTime() > System.currentTimeMillis()) {
            new DeferedStartTask(message);
        } else {
            this.processMessageInternal(message);
        }
    }

    protected void processMessageInternal(Message message) {
        Schedulable schedulable = this.taskFactory_.newFilterProxyConsumerTask(message);
        schedulable.schedule();
    }

    public void scheduleTimedPullTask(MessageSupplier messageSupplier) {
        PullFromSupplierTask pullFromSupplierTask = new PullFromSupplierTask(this.pullTaskExecutor_);
        pullFromSupplierTask.setTarget(messageSupplier);
        pullFromSupplierTask.schedule();
    }

    private ScheduledExecutorService getClockDaemon() {
        return this.clockDaemon_;
    }

    public ScheduledFuture executeTaskPeriodically(long l, Runnable runnable, boolean bl) {
        return this.getClockDaemon().scheduleAtFixedRate(runnable, bl ? 0L : l, l, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture executeTaskAfterDelay(long l, Runnable runnable) {
        return this.clockDaemon_.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    Object executeTaskAt(long l, Runnable runnable) {
        return this.executeTaskAt(new Date(l), runnable);
    }

    Object executeTaskAt(Date date, Runnable runnable) {
        long l = System.currentTimeMillis();
        long l2 = date.getTime();
        long l3 = l2 - l;
        if (l3 < 1000L) {
            l3 = 1000L;
        }
        return this.clockDaemon_.schedule(runnable, l3, TimeUnit.MILLISECONDS);
    }

    private void fireEventDiscarded(Message message) {
        switch (message.getType()) {
            case 0: {
                this.fireEventDiscarded(message.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(message.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void fireEventDiscarded(Any any) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + any + " has been discarded");
        }
    }

    private void fireEventDiscarded(StructuredEvent structuredEvent) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + structuredEvent + " has been discarded");
        }
    }

    public String getJMXObjectName() {
        return "service=TaskProcessor";
    }

    public void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public String[] getJMXNotificationTypes() {
        return null;
    }

    public void setJMXCallback(JMXManageable.JMXCallback jMXCallback) {
    }

    public int getFilterWorkerPoolSize() {
        return this.filterWorkerPoolSize_;
    }

    public int getPullWorkerPoolSize() {
        return this.pullWorkerPoolSize_;
    }

    class DeferedStartTask
    implements Runnable {
        final Message message_;

        DeferedStartTask(Message message) {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Message with Option StartTime=" + message.getStartTime() + " will be defered until then");
            }
            this.message_ = message;
            DefaultTaskProcessor.this.executeTaskAt(this.message_.getStartTime(), (Runnable)this);
        }

        public void run() {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            DefaultTaskProcessor.this.processMessageInternal(this.message_);
        }
    }

    private class DeferedStopTask
    implements Runnable {
        final Message message_;

        public DeferedStopTask(Message message) {
            this.message_ = message;
            DefaultTaskProcessor.this.executeTaskAt(message.getStopTime(), (Runnable)this);
        }

        public void run() {
            this.message_.actionTimeout();
        }
    }

    private class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        ScheduledFuture timerRegistration_;
        final Message message_;

        public TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }

        public void actionLifetimeChanged(long l) {
            this.timerRegistration_.cancel(true);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            DefaultTaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }
    }
}

