/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ServantLifecyleControl;
import org.jacorb.notification.servant.AbstractProxyMBean;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;

public abstract class AbstractProxy
implements FilterAdminOperations,
QoSAdminOperations,
FilterStage,
IServantLifecyle,
Configurable,
JMXManageable,
AbstractProxyMBean {
    private final MappingFilter nullMappingFilterRef_;
    private final boolean isIDPublic_;
    protected final Logger logger_;
    private final AtomicBoolean connected_ = new AtomicBoolean(false);
    protected final QoSPropertySet qosSettings_;
    private final Integer id_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    private MappingFilter lifetimeFilter_;
    private MappingFilter priorityFilter_;
    private final FilterManager filterManager_;
    private final AtomicBoolean destroyed_ = new AtomicBoolean(false);
    private final AtomicBoolean disposeInProgress_ = new AtomicBoolean(false);
    private final AtomicInteger errorCounter_ = new AtomicInteger(0);
    private final POA poa_;
    private final ORB orb_;
    private final TaskProcessor taskProcessor_;
    private boolean isInterFilterGroupOperatorOR_;
    private final boolean disposedProxyDisconnectsClient_;
    private final AtomicBoolean active_ = new AtomicBoolean(true);
    private final DisposableManager disposables_ = new DisposableManager();
    private final PicoContainer container_;
    private Object client_;
    private final String parentMBean_;
    protected final Set eventTypes_ = new HashSet();
    private JMXManageable.JMXCallback jmxCallback_;
    protected Configuration config_;
    private final ServantLifecyleControl servantLifecycle_;

    protected AbstractProxy(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.parentMBean_ = iAdmin.getAdminMBean();
        this.id_ = new Integer(iAdmin.getProxyID());
        this.isIDPublic_ = iAdmin.isIDPublic();
        this.container_ = iAdmin.getContainer();
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.taskProcessor_ = taskProcessor;
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
        this.filterManager_ = new FilterManager();
        this.nullMappingFilterRef_ = MappingFilterHelper.narrow(oRB.string_to_object(oRB.object_to_string(null)));
        this.logger_ = configuration.getLogger(this.getClass().getName());
        this.disposedProxyDisconnectsClient_ = configuration.getAttribute("jacorb.notification.proxy.destroy_causes_disconnect", "on").equals("on");
        this.qosSettings_ = new QoSPropertySet(configuration, 2);
        this.servantLifecycle_ = new ServantLifecyleControl((IServantLifecyle)this, configuration);
        this.configure(configuration);
    }

    public void configure(Configuration configuration) {
        this.config_ = configuration;
    }

    public void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public boolean isIDPublic() {
        return this.isIDPublic_;
    }

    public final POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public final Object activate() {
        return this.servantLifecycle_.activate();
    }

    protected TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public final int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public final void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public final Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public final int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public final void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public void validate_event_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) {
        throw new NO_IMPLEMENT();
    }

    public final void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public final void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.set_qos(propertyArray);
    }

    public final Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public final void priority_filter(MappingFilter mappingFilter) {
        this.priorityFilter_ = mappingFilter;
    }

    public final MappingFilter priority_filter() {
        if (this.priorityFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.priorityFilter_;
    }

    public final MappingFilter lifetime_filter() {
        if (this.lifetimeFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.lifetimeFilter_;
    }

    public final void lifetime_filter(MappingFilter mappingFilter) {
        this.lifetimeFilter_ = mappingFilter;
    }

    public final Integer getID() {
        return this.id_;
    }

    public final List getFilters() {
        return this.filterManager_.getFilters();
    }

    public final void deactivate() {
        this.servantLifecycle_.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDisconnectClient() {
        try {
            if (this.disposedProxyDisconnectsClient_ && this.connected_.get()) {
                this.logger_.info("disconnect_client");
                this.disconnectClient();
                this.client_._release();
            }
        }
        catch (Exception exception) {
            this.logger_.info("disconnect_client raised an unexpected error: will be ignored", (Throwable)exception);
        }
        finally {
            this.connected_.set(false);
            this.client_ = null;
        }
    }

    public final boolean isDestroyed() {
        return this.destroyed_.get();
    }

    protected void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.destroyed_.compareAndSet(false, true)) {
            this.logger_.error("Already destroyed");
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(IContainer.class);
        for (IContainer iContainer : list) {
            iContainer.destroy();
        }
    }

    public void dispose() {
        this.logger_.info("Destroy Proxy " + this.id_);
        this.disposeInProgress_.set(true);
        this.tryDisconnectClient();
        this.clientDisconnected();
        this.removeListener();
        this.remove_all_filters();
        this.disposables_.dispose();
        this.deactivate();
    }

    protected abstract void clientDisconnected();

    public abstract ProxyType MyType();

    void setInterFilterGroupOperatorOR(boolean bl) {
        this.isInterFilterGroupOperatorOR_ = bl;
    }

    public final boolean hasInterFilterGroupOperatorOR() {
        return this.isInterFilterGroupOperatorOR_;
    }

    public final boolean getConnected() {
        return !this.disposeInProgress_.get() && this.connected_.get();
    }

    public final boolean hasLifetimeFilter() {
        return this.lifetimeFilter_ != null;
    }

    public final boolean hasPriorityFilter() {
        return this.priorityFilter_ != null;
    }

    public final MappingFilter getLifetimeFilter() {
        return this.lifetimeFilter_;
    }

    public final MappingFilter getPriorityFilter() {
        return this.priorityFilter_;
    }

    public void resetErrorCounter() {
        this.errorCounter_.set(0);
    }

    public final int getErrorCounter() {
        return this.errorCounter_.get();
    }

    public final int incErrorCounter() {
        return this.errorCounter_.getAndIncrement();
    }

    public boolean isSuspended() {
        return !this.active_.get();
    }

    public final void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.checkIsConnected();
        if (!this.active_.compareAndSet(true, false)) {
            throw new ConnectionAlreadyInactive();
        }
        this.connectionSuspended();
    }

    protected void connectionSuspended() {
    }

    public final void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.checkIsConnected();
        if (!this.active_.compareAndSet(false, true)) {
            throw new ConnectionAlreadyActive();
        }
        this.connectionResumed();
    }

    protected void connectionResumed() {
    }

    protected void checkIsConnected() throws NotConnected {
        if (!this.connected_.get()) {
            throw new NotConnected();
        }
    }

    protected void checkIsNotConnected() throws AlreadyConnected {
        if (this.connected_.get()) {
            throw new AlreadyConnected();
        }
    }

    protected void checkStillConnected() throws Disconnected {
        if (!this.connected_.get()) {
            this.logger_.error("access on a not connected proxy");
            this.destroy();
            throw new Disconnected();
        }
    }

    protected void connectClient(Object object) {
        this.connected_.set(true);
        this.client_ = object;
    }

    protected abstract void disconnectClient();

    protected void handleDisconnected(Disconnected disconnected) {
        this.logger_.error("Illegal state: Client think it's disconnected. Proxy thinks Client is still connected. The Proxy will be destroyed.", (Throwable)disconnected);
        this.destroy();
    }

    protected abstract void removeListener();

    public final String getJMXObjectName() {
        return this.parentMBean_ + ", proxy=" + this.getMBeanName();
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected String getMBeanType() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2.substring(0, string2.length() - "Impl".length());
    }

    public String[] getJMXNotificationTypes() {
        return this.eventTypes_.toArray(new String[this.eventTypes_.size()]);
    }

    public void setJMXCallback(JMXManageable.JMXCallback jMXCallback) {
        this.jmxCallback_ = jMXCallback;
    }

    protected void sendNotification(String string, String string2) {
        if (this.jmxCallback_ != null) {
            this.jmxCallback_.sendJMXNotification(string, string2);
        }
    }

    protected void sendNotification(String string, String string2, java.lang.Object object) {
        if (this.jmxCallback_ != null) {
            this.jmxCallback_.sendJMXNotification(string, string2, object);
        }
    }

    public String getStatus() {
        String string = this.destroyed_.get() ? "DESTROYED" : (!this.connected_.get() ? "NOT CONNECTED" : (this.active_.get() ? "ACTIVE" : "SUSPENDED"));
        return string;
    }

    public String getClientIOR() {
        return this.client_ != null ? this.orb_.object_to_string(this.client_) : "";
    }

    public String getInterFilterGroupOperator() {
        return this.isInterFilterGroupOperatorOR_ ? "OR_OP" : "AND_OP";
    }
}

