/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.InvalidBytecodeException;
import org.jboss.classfilewriter.code.StackEntry;
import org.jboss.classfilewriter.code.StackEntryType;
import org.jboss.classfilewriter.constpool.ConstPool;

public class LocalVariableState {
    private final List<StackEntry> contents;
    private final ConstPool constPool;

    public LocalVariableState(ClassMethod method) {
        this.constPool = method.getClassFile().getConstPool();
        this.contents = new ArrayList<StackEntry>();
        if (!method.isStatic()) {
            if (method.isConstructor()) {
                this.contents.add(new StackEntry(StackEntryType.UNINITIALIZED_THIS, method.getClassFile().getDescriptor()));
            } else {
                this.contents.add(StackEntry.of(method.getClassFile().getDescriptor(), method.getClassFile().getConstPool()));
            }
        }
        for (String param : method.getParameters()) {
            StackEntry entry = StackEntry.of(param, method.getClassFile().getConstPool());
            this.contents.add(entry);
            if (!entry.isWide()) continue;
            this.contents.add(new StackEntry(StackEntryType.TOP, param));
        }
    }

    private LocalVariableState(List<StackEntry> contents, ConstPool constPool) {
        this.contents = contents;
        this.constPool = constPool;
    }

    public List<StackEntry> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public StackEntry get(int index) {
        return this.contents.get(index);
    }

    public LocalVariableState storeWide(int index, StackEntry entry) {
        ArrayList<StackEntry> newContents = new ArrayList<StackEntry>(this.contents.size());
        for (int i = 0; i <= index || i < this.contents.size(); ++i) {
            if (index == i) {
                newContents.add(entry);
                newContents.add(new StackEntry(StackEntryType.TOP, entry.getDescriptor()));
                ++i;
                continue;
            }
            if (i >= this.contents.size()) {
                newContents.add(new StackEntry(StackEntryType.NULL, null));
                continue;
            }
            newContents.add(this.contents.get(i));
        }
        return new LocalVariableState(newContents, this.constPool);
    }

    public LocalVariableState store(int index, StackEntry entry) {
        ArrayList<StackEntry> newContents = new ArrayList<StackEntry>(this.contents.size());
        for (int i = 0; i <= index || i < this.contents.size(); ++i) {
            if (index == i) {
                newContents.add(entry);
                continue;
            }
            if (i >= this.contents.size()) {
                newContents.add(new StackEntry(StackEntryType.NULL, null));
                continue;
            }
            newContents.add(this.contents.get(i));
        }
        return new LocalVariableState(newContents, this.constPool);
    }

    public int size() {
        return this.contents.size();
    }

    public String toString() {
        return "Local Variables: " + this.contents.toString();
    }

    public LocalVariableState constructorCall(StackEntry entry) {
        ArrayList<StackEntry> newContents = new ArrayList<StackEntry>(this.contents.size());
        if (entry.getType() == StackEntryType.UNINITIALIZED_THIS) {
            for (int i = 0; i < this.contents.size(); ++i) {
                StackEntry stackEntry = this.contents.get(i);
                if (stackEntry.getType() == StackEntryType.UNINITIALIZED_THIS) {
                    newContents.add(StackEntry.of(stackEntry.getDescriptor(), this.constPool));
                    continue;
                }
                newContents.add(stackEntry);
            }
            return new LocalVariableState(newContents, this.constPool);
        }
        if (entry.getType() == StackEntryType.UNITITIALIZED_OBJECT) {
            for (int i = 0; i < this.contents.size(); ++i) {
                StackEntry stackEntry = this.contents.get(i);
                if (stackEntry.getType() == StackEntryType.UNITITIALIZED_OBJECT && stackEntry.getNewInstructionLocation() == entry.getNewInstructionLocation()) {
                    newContents.add(StackEntry.of(stackEntry.getDescriptor(), this.constPool));
                    continue;
                }
                newContents.add(stackEntry);
            }
            return new LocalVariableState(newContents, this.constPool);
        }
        throw new InvalidBytecodeException("entry is not an unitialized object. " + this.toString());
    }
}

