/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.tx.BMTInterceptor;
import org.jboss.as.ejb3.tx.util.StatusHelper;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class StatefulBMTInterceptor
extends BMTInterceptor {
    private static final Logger log = Logger.getLogger(StatefulBMTInterceptor.class);
    private volatile Transaction transaction;

    public StatefulBMTInterceptor(EJBComponent component) {
        super(component);
    }

    private void checkBadStateful() {
        int status = 6;
        TransactionManager tm = this.getComponent().getTransactionManager();
        try {
            status = tm.getStatus();
        }
        catch (SystemException ex) {
            log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    tm.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + this.getComponent().getComponentName() + "' did not complete user transaction properly status=" + StatusHelper.statusAsString(status);
                log.error((Object)msg);
            }
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    protected Object handleInvocation(InterceptorContext invocation) throws Exception {
        TransactionManager tm = this.getComponent().getTransactionManager();
        assert (tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        Transaction tx = this.transaction;
        if (tx != null) {
            this.transaction = null;
            tm.resume(tx);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable e) {
            throw this.handleException(invocation, e);
        }
        finally {
            this.checkBadStateful();
            Transaction newTx = tm.getTransaction();
            if (newTx != null) {
                this.transaction = newTx;
                tm.suspend();
            } else {
                this.transaction = null;
            }
        }
    }
}

