/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.net.InetAddress;

class NetworkUtil {
    NetworkUtil() {
    }

    static boolean belongsToNetwork(InetAddress address, InetAddress networkAddress, byte networkMask) {
        byte[] networkAddressBytes;
        if (address == null || networkAddress == null) {
            return false;
        }
        if (networkMask == 0) {
            return true;
        }
        byte[] addressBytes = address.getAddress();
        if (addressBytes.length != (networkAddressBytes = networkAddress.getAddress()).length) {
            return false;
        }
        int currentByte = 0;
        byte networkAddressByte = networkAddressBytes[currentByte];
        byte otherAddressByte = addressBytes[currentByte];
        for (int i = 0; i < networkMask; ++i) {
            if ((networkAddressByte & 0x80) != (otherAddressByte & 0x80)) {
                return false;
            }
            if ((i + 1) % 8 == 0) {
                if (currentByte == networkAddressBytes.length - 1) {
                    return true;
                }
                networkAddressByte = networkAddressBytes[++currentByte];
                otherAddressByte = addressBytes[currentByte];
                continue;
            }
            networkAddressByte = (byte)(networkAddressByte << 1);
            otherAddressByte = (byte)(otherAddressByte << 1);
        }
        return true;
    }

    static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }
}

