/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentMessages;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.TargetModuleIDImpl;
import org.jboss.as.ee.deployment.spi.URIParser;
import org.jboss.dmr.ModelNode;

final class DeploymentManagerTarget
extends JBossTarget {
    static final String DESCRIPTION = "ServerDeploymentManager target";
    private final Map<TargetModuleID, Boolean> runtimeState = new HashMap<TargetModuleID, Boolean>();
    private final ModelControllerClient modelControllerClient;
    private final ServerDeploymentManager deploymentManager;
    private final URI deployURI;

    public DeploymentManagerTarget(URI deployURI, String username, String password) {
        DeploymentLogger.ROOT_LOGGER.debugf("new DeploymentManagerTarget: %s", deployURI);
        try {
            URIParser parser = new URIParser(deployURI);
            String serverHost = parser.getParameter("serverHost");
            String serverPort = parser.getParameter("serverPort");
            String host = serverHost != null ? serverHost : "127.0.0.1";
            Integer port = serverPort != null ? Integer.parseInt(serverPort) : 9999;
            this.modelControllerClient = username != null && password != null ? ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)this.getCallbackHandler(username, password)) : ModelControllerClient.Factory.create((String)host, (int)port);
            this.deploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient);
            this.deployURI = deployURI;
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(DeploymentMessages.MESSAGES.cannotConnectToManagementTarget(deployURI), ex);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return this.deployURI.toString();
    }

    @Override
    public void deploy(TargetModuleID targetModuleID) throws Exception {
        DeploymentLogger.ROOT_LOGGER.beginDeploy(targetModuleID);
        String deploymentName = targetModuleID.getModuleID();
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        builder = builder.add(deploymentName, new URL(deploymentName)).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        this.executeDeploymentPlan(plan, deployAction);
        DeploymentLogger.ROOT_LOGGER.endDeploy(targetModuleID);
    }

    @Override
    public void start(TargetModuleID targetModuleID) throws Exception {
        ((TargetModuleIDImpl)targetModuleID).setRunning(Boolean.TRUE);
        this.runtimeState.put(targetModuleID, Boolean.TRUE);
    }

    @Override
    public void stop(TargetModuleID targetModuleID) throws Exception {
        ((TargetModuleIDImpl)targetModuleID).setRunning(Boolean.FALSE);
        this.runtimeState.put(targetModuleID, Boolean.FALSE);
    }

    @Override
    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        String deploymentName = targetModuleID.getModuleID();
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        DeploymentPlan plan = builder.undeploy(deploymentName).remove(deploymentName).build();
        Future future = this.deploymentManager.execute(plan);
        future.get();
    }

    @Override
    public TargetModuleID[] getAvailableModules(ModuleType filterType) throws TargetException {
        try {
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-children-names");
            operation.get("child-type").set("deployment");
            ModelNode result = this.modelControllerClient.execute(operation);
            if ("failed".equals(result.get("outcome").asString())) {
                throw new IllegalStateException(DeploymentMessages.MESSAGES.managementRequestFailed(result));
            }
            List nodeList = result.get("result").asList();
            for (ModelNode node : nodeList) {
                TargetModuleIDImpl targetModuleID;
                String moduleID = node.asString();
                ModuleType moduleType = null;
                if (moduleID.endsWith(".ear")) {
                    moduleType = ModuleType.EAR;
                } else if (moduleID.endsWith(".war")) {
                    moduleType = ModuleType.WAR;
                } else if (moduleID.endsWith(".rar")) {
                    moduleType = ModuleType.RAR;
                } else if (moduleID.endsWith(".jar")) {
                    moduleType = ModuleType.EJB;
                }
                if (moduleType == null) {
                    DeploymentLogger.ROOT_LOGGER.cannotDetermineModuleType(node);
                    continue;
                }
                if (filterType != null && !filterType.equals(moduleType)) continue;
                Boolean state = this.runtimeState.get(targetModuleID = new TargetModuleIDImpl(this, moduleID, null, moduleType));
                targetModuleID.setRunning(state != null ? state : Boolean.TRUE);
                list.add(targetModuleID);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            TargetException tex = new TargetException("Failed to get available modules");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
    }

    private CallbackHandler getCallbackHandler(final String username, final String password) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }
}

