/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.ProxyTask;
import org.jboss.dmr.ModelNode;

public class DomainSlaveHandler
implements OperationStepHandler {
    private final ExecutorService executorService;
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, DomainOperationContext domainOperationContext, ExecutorService executorService) {
        this.hostProxies = hostProxies;
        this.domainOperationContext = domainOperationContext;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.completeStep();
            return;
        }
        HashMap<String, ProxyTask> tasks = new HashMap<String, ProxyTask>();
        HashMap<String, Future<ModelNode>> futures = new HashMap<String, Future<ModelNode>>();
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            ProxyTask proxyTask = new ProxyTask(host, operation.clone(), context, entry.getValue());
            tasks.put(host, proxyTask);
            futures.put(host, this.executorService.submit(proxyTask));
        }
        boolean interrupted = false;
        try {
            for (Map.Entry entry : tasks.entrySet()) {
                ModelNode result;
                ProxyTask proxyTask = (ProxyTask)entry.getValue();
                try {
                    result = ((ProxyTask)entry.getValue()).getUncommittedResult();
                }
                catch (Exception e) {
                    result = new ModelNode();
                    result.get("outcome").set("failed");
                    if (e instanceof InterruptedException) {
                        result.get("failure-description").set(DomainControllerMessages.MESSAGES.interruptedAwaitingResultFromHost((String)entry.getKey()));
                        interrupted = true;
                    } else {
                        result.get("failure-description").set(DomainControllerMessages.MESSAGES.exceptionAwaitingResultFromHost((String)entry.getKey(), e.getMessage()));
                    }
                    proxyTask.cancel();
                    ((Future)futures.get(entry.getKey())).cancel(true);
                }
                if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Preliminary result for remote host %s is %s", entry.getKey(), result);
                }
                this.domainOperationContext.addHostControllerResult((String)entry.getKey(), result);
            }
            context.completeStep();
        }
        catch (Throwable throwable) {
            try {
                boolean rollback = this.domainOperationContext.isCompleteRollback();
                for (ProxyTask proxyTask : tasks.values()) {
                    proxyTask.finalizeTransaction(!rollback);
                }
                for (Map.Entry entry : futures.entrySet()) {
                    Future future = (Future)entry.getValue();
                    try {
                        ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                        this.domainOperationContext.addHostControllerResult((String)entry.getKey(), finalResult);
                        if (!DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) continue;
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", entry.getKey(), finalResult);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        DomainControllerLogger.CONTROLLER_LOGGER.interruptedAwaitingFinalResponse((String)entry.getKey());
                    }
                    catch (ExecutionException e) {
                        DomainControllerLogger.CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), (String)entry.getKey());
                    }
                }
                throw throwable;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        try {
            boolean rollback = this.domainOperationContext.isCompleteRollback();
            for (ProxyTask proxyTask : tasks.values()) {
                proxyTask.finalizeTransaction(!rollback);
            }
            for (Map.Entry entry : futures.entrySet()) {
                Future future = (Future)entry.getValue();
                try {
                    ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                    this.domainOperationContext.addHostControllerResult((String)entry.getKey(), finalResult);
                    if (!DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) continue;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", entry.getKey(), finalResult);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    DomainControllerLogger.CONTROLLER_LOGGER.interruptedAwaitingFinalResponse((String)entry.getKey());
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), (String)entry.getKey());
                }
            }
            return;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ModelNode getCancelledResult() {
        ModelNode cancelled = new ModelNode();
        cancelled.get("outcome").set("cancelled");
        return cancelled;
    }
}

