/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadURLHandler
extends AbstractDeploymentUploadHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "upload-deployment-url";
    private final ParametersValidator urlValidator = new ParametersValidator();

    public DeploymentUploadURLHandler() {
        this(null);
    }

    public DeploymentUploadURLHandler(ContentRepository repository) {
        super(repository);
        this.urlValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getUploadDeploymentURLOperation((Locale)locale);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        this.urlValidator.validate(operation);
        String urlSpec = operation.get("url").asString();
        try {
            URL url = new URL(urlSpec);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidUrl(urlSpec, e.toString())));
        }
        catch (IOException e) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.errorObtainingUrlStream(urlSpec, e.toString())));
        }
    }
}

