/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.injection.FieldInjectionPoint;
import org.jboss.as.weld.injection.InjectableConstructor;
import org.jboss.as.weld.injection.InjectableField;
import org.jboss.as.weld.injection.InjectableMethod;
import org.jboss.as.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

class WeldEEInjection {
    private final Class<?> componentClass;
    private final BeanManagerImpl beanManager;
    private final List<InjectableField> injectableFields;
    private final List<InjectableMethod> injectableMethods;
    private final InjectableConstructor constructor;
    private final InjectionTarget injectionTarget;

    public WeldEEInjection(Class<?> componentClass, BeanManagerImpl beanManager, List<InjectableField> injectableFields, List<InjectableMethod> injectableMethods, InjectableConstructor constructor, InjectionTarget injectionTarget) {
        this.componentClass = componentClass;
        this.beanManager = beanManager;
        this.injectableFields = injectableFields;
        this.injectableMethods = injectableMethods;
        this.constructor = constructor;
        this.injectionTarget = injectionTarget;
    }

    public void inject(Object instance, CreationalContext<?> ctx) {
        if (this.injectionTarget != null) {
            this.injectionTarget.inject(instance, ctx);
        }
        for (InjectableField field : this.injectableFields) {
            field.inject(instance, this.beanManager, ctx);
        }
        for (InjectableMethod method : this.injectableMethods) {
            method.inject(instance, this.beanManager, ctx);
        }
    }

    public Object produce(CreationalContext<?> ctx) {
        try {
            if (this.constructor != null) {
                return this.constructor.createInstance(ctx);
            }
            return this.componentClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static WeldEEInjection createWeldEEInjection(Class<?> componentClass, Bean<?> bean, BeanManagerImpl beanManager) {
        InjectionTarget injectionTarget;
        WeldClass type = ((ClassTransformer)beanManager.getServices().get(ClassTransformer.class)).loadClass(componentClass);
        ArrayList<InjectableField> injectableFields = new ArrayList<InjectableField>();
        ArrayList<InjectableMethod> injectableMethods = new ArrayList<InjectableMethod>();
        AnnotatedConstructor injectConstructor = null;
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            if (injectConstructor != null) {
                throw WeldMessages.MESSAGES.moreThanOneBeanConstructor(componentClass);
            }
            injectConstructor = constructor;
        }
        InjectableConstructor constructor = null;
        if (injectConstructor != null) {
            constructor = new InjectableConstructor(injectConstructor, beanManager, bean);
        }
        if (bean instanceof AbstractClassBean) {
            injectionTarget = ((AbstractClassBean)bean).getInjectionTarget();
        } else {
            injectionTarget = null;
            for (AnnotatedField field : type.getFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                if (InjectionPoint.class.isAssignableFrom(field.getJavaMember().getType())) {
                    throw WeldMessages.MESSAGES.attemptingToInjectInjectionPointIntoField(componentClass, field.getJavaMember());
                }
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                for (Annotation annotation : field.getAnnotations()) {
                    if (!beanManager.isQualifier(annotation.annotationType())) continue;
                    qualifiers.add(annotation);
                }
                FieldInjectionPoint ip = new FieldInjectionPoint(field, qualifiers, bean);
                Set beans = beanManager.getBeans((InjectionPoint)ip);
                Bean ipBean = beanManager.resolve(beans);
                if (ipBean == null) {
                    throw WeldMessages.MESSAGES.couldNotResolveInjectionPoint(field.getJavaMember().toGenericString(), qualifiers);
                }
                injectableFields.add(new InjectableField(field.getJavaMember(), ipBean, ip));
            }
            for (AnnotatedMethod method : type.getMethods()) {
                if (!method.isAnnotationPresent(Inject.class)) continue;
                ArrayList parameterBeans = new ArrayList();
                ArrayList<InjectionPoint> ips = new ArrayList<InjectionPoint>();
                for (AnnotatedParameter param : method.getParameters()) {
                    HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                    for (Annotation annotation : param.getAnnotations()) {
                        if (!beanManager.isQualifier(annotation.annotationType())) continue;
                        qualifiers.add(annotation);
                    }
                    Class<?> parameterType = method.getJavaMember().getParameterTypes()[param.getPosition()];
                    if (InjectionPoint.class.isAssignableFrom(parameterType)) {
                        throw WeldMessages.MESSAGES.attemptingToInjectInjectionPointIntoNonBean(componentClass, method.getJavaMember());
                    }
                    ParameterInjectionPoint ip = new ParameterInjectionPoint(param, qualifiers, bean);
                    Set beans = beanManager.getBeans((InjectionPoint)ip);
                    Bean ipBean = beanManager.resolve(beans);
                    if (ipBean == null) {
                        throw WeldMessages.MESSAGES.couldNotResolveInjectionPoint(param.toString(), qualifiers);
                    }
                    parameterBeans.add(ipBean);
                    ips.add(ip);
                }
                injectableMethods.add(new InjectableMethod(method.getJavaMember(), parameterBeans, ips));
            }
        }
        return new WeldEEInjection(componentClass, beanManager, injectableFields, injectableMethods, constructor, injectionTarget);
    }
}

