/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class ModClusterSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final ModClusterSubsystemAdd INSTANCE = new ModClusterSubsystemAdd();

    ModClusterSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        if (operation.hasDefined("mod-cluster-config")) {
            ModelNode configuration = operation.get("mod-cluster-config").hasDefined("configuration") ? operation.get("mod-cluster-config").get("configuration") : operation.get("mod-cluster-config");
            resource.registerChild(ModClusterExtension.configurationPath, Resource.Factory.create());
            Resource conf = resource.getChild(ModClusterExtension.configurationPath);
            ModelNode confModel = conf.getModel();
            for (String attribute : configuration.keys()) {
                if (attribute.equals("ssl")) {
                    conf.registerChild(ModClusterExtension.sslConfigurationPath, Resource.Factory.create());
                    Resource ssl = conf.getChild(ModClusterExtension.sslConfigurationPath);
                    ModelNode sslnode = configuration.get(attribute).hasDefined("configuration") ? configuration.get(attribute).get("configuration") : configuration.get(attribute);
                    ModelNode sslModel = ssl.getModel();
                    for (AttributeDefinition sslAttr : ModClusterSSLResourceDefinition.ATTRIBUTES) {
                        sslAttr.validateAndSet(sslnode, sslModel);
                    }
                    continue;
                }
                if (attribute.equals("dynamic-load-provider") || attribute.equals("simple-load-provider")) {
                    confModel.get(attribute).set(configuration.get(attribute));
                    continue;
                }
                AttributeDefinition ad = (AttributeDefinition)ModClusterConfigResourceDefinition.ATTRIBUTES_BY_NAME.get(attribute);
                if (ad == null) continue;
                ad.validateAndSet(configuration, confModel);
            }
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String bindingRef;
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode unresolvedConfig = fullModel.get(new String[]{ModClusterExtension.configurationPath.getKey(), ModClusterExtension.configurationPath.getValue()});
        ModelNode resolvedConfig = this.resolveConfig(context, unresolvedConfig);
        ModClusterService service = new ModClusterService(resolvedConfig);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ModClusterService.NAME, (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getBindingManager()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE);
        ModelNode bindingRefNode = resolvedConfig.get(ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.getName());
        String string = bindingRef = bindingRefNode.isDefined() ? bindingRefNode.asString() : null;
        if (bindingRef != null) {
            serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
        }
        newControllers.add(serviceBuilder.install());
    }

    private ModelNode resolveConfig(OperationContext context, ModelNode unresolvedConfig) throws OperationFailedException {
        ModelNode resolved = new ModelNode();
        for (AttributeDefinition coreAttr : ModClusterConfigResourceDefinition.ATTRIBUTES) {
            resolved.get(coreAttr.getName()).set(coreAttr.resolveModelAttribute(context, unresolvedConfig));
        }
        ModelNode unresolvedSSL = unresolvedConfig.get(new String[]{ModClusterExtension.sslConfigurationPath.getKey(), ModClusterExtension.sslConfigurationPath.getValue()});
        if (unresolvedSSL.isDefined()) {
            ModelNode resolvedSSL = resolved.get(new String[]{ModClusterExtension.sslConfigurationPath.getKey(), ModClusterExtension.sslConfigurationPath.getValue()});
            for (AttributeDefinition sslAttr : ModClusterConfigResourceDefinition.ATTRIBUTES) {
                resolvedSSL.get(sslAttr.getName()).set(sslAttr.resolveModelAttribute(context, unresolvedSSL));
            }
        }
        for (Property property : unresolvedConfig.asPropertyList()) {
            String key = property.getName();
            if (ModClusterConfigResourceDefinition.ATTRIBUTES_BY_NAME.containsKey(key) || key.equals(ModClusterExtension.sslConfigurationPath.getKey())) continue;
            resolved.get(key).set(context.resolveExpressions(property.getValue()));
        }
        return resolved;
    }

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getSubsystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }
}

