/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.loggers.AbstractLogHandlerAssignmentHandler;
import org.jboss.as.logging.util.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class LoggerUnassignHandler
extends AbstractLogHandlerAssignmentHandler {
    public static final String OPERATION_NAME = "unassign-handler";
    public static final LoggerUnassignHandler INSTANCE = new LoggerUnassignHandler();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.updateHandlersForUnassign((AttributeDefinition)CommonAttributes.HANDLERS, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        LoggerUnassignHandler.removeHandler(context, this.getLoggerName(operation), this.getHandlerName(operation));
    }

    @Override
    protected String getHandlerName(ModelNode operation) throws OperationFailedException {
        return CommonAttributes.NAME.validateOperation(operation).asString();
    }

    protected String getLoggerName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.getLastElement().getValue();
    }

    public static void removeHandler(OperationContext context, String loggerName, String handlerName) throws OperationFailedException {
        if (context.getServiceRegistry(false).getService(LogServices.loggerName(loggerName)) == null) {
            throw LoggerUnassignHandler.createFailureMessage(LoggingMessages.MESSAGES.loggerNotFound(loggerName));
        }
        context.removeService(LogServices.loggerHandlerName(loggerName, handlerName));
    }

    public static void removeHandlers(AttributeDefinition attribute, ModelNode node, OperationContext context, String loggerName) throws OperationFailedException {
        if (context.getServiceRegistry(false).getService(LogServices.loggerName(loggerName)) == null) {
            throw LoggerUnassignHandler.createFailureMessage(LoggingMessages.MESSAGES.loggerNotFound(loggerName));
        }
        ModelNode handlers = attribute.resolveModelAttribute(context, node);
        if (handlers.isDefined() && handlers.getType() == ModelType.LIST) {
            for (ModelNode handler : handlers.asList()) {
                LoggerUnassignHandler.removeHandler(context, loggerName, handler.asString());
            }
        }
    }
}

