/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.metadata.wsse.Authenticate;
import org.jboss.ws.metadata.wsse.Authorize;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Role;
import org.jboss.ws.metadata.wsse.SecurityDomain;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.SignatureCertAuth;
import org.jboss.ws.metadata.wsse.Target;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.TimestampVerification;
import org.jboss.ws.metadata.wsse.Unchecked;
import org.jboss.ws.metadata.wsse.Username;
import org.jboss.ws.metadata.wsse.UsernameAuth;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class WSSecurityOMFactory
implements ObjectModelFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSSecurityOMFactory.class);
    public static final String SERVER_RESOURCE_NAME = "jboss-wsse-server.xml";
    public static final String CLIENT_RESOURCE_NAME = "jboss-wsse-client.xml";
    private static HashMap<String, String> options = new HashMap(7);
    private static final Logger log;

    private WSSecurityOMFactory() {
    }

    public static WSSecurityOMFactory newInstance() {
        return new WSSecurityOMFactory();
    }

    public WSSecurityConfiguration parse(URL configURL) throws IOException {
        if (configURL == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITY_CONFIG_URL_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        InputStream is = new ResourceURL(configURL).openStream();
        try {
            WSSecurityConfiguration configuration;
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            WSSecurityConfiguration wSSecurityConfiguration = configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(is, (ObjectModelFactory)this, null);
            return wSSecurityConfiguration;
        }
        catch (JBossXBException e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE", (Object[])new Object[]{configURL}), (Throwable)e);
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE", (Object[])new Object[]{configURL}));
            Throwable cause = e.getCause();
            if (cause != null) {
                ioex.initCause(cause);
            }
            throw ioex;
        }
        finally {
            is.close();
        }
    }

    public WSSecurityConfiguration parse(String xmlString) throws JBossXBException {
        if (xmlString == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITY_CONFIG_XML_STRING_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(xmlString, (ObjectModelFactory)this, null);
        return configuration;
    }

    public WSSecurityConfiguration parse(StringReader strReader) throws JBossXBException {
        if (strReader == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITY_INPUTSTREAM_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal((Reader)strReader, (ObjectModelFactory)this, null);
        return configuration;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return new WSSecurityConfiguration();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public void setValue(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + configuration + ",value=" + value + "]"));
        String method = options.get(localName);
        if (method == null) {
            return;
        }
        try {
            WSSecurityConfiguration.class.getMethod(method, String.class).invoke((Object)configuration, value);
        }
        catch (Exception e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_SET_OPTION", (Object[])new Object[]{method, value}), (Throwable)e);
        }
    }

    public Object newChild(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        if ("key-passwords".equals(localName)) {
            HashMap<String, String> pwds = new HashMap<String, String>();
            configuration.setKeyPasswords(pwds);
            return pwds;
        }
        if ("port".equals(localName)) {
            return new Port(attrs.getValue("", "name"));
        }
        if ("timestamp-verification".equals(localName)) {
            Long createdTolerance = 0L;
            String createdToleranceAttr = attrs.getValue("", "createdTolerance");
            if (createdToleranceAttr != null) {
                createdTolerance = (Long)SimpleTypeBindings.unmarshal((String)"long", (String)createdToleranceAttr, null);
            }
            Boolean warnCreated = new Boolean(true);
            String warnCreatedAttr = attrs.getValue("", "warnCreated");
            if (warnCreatedAttr != null) {
                warnCreated = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)warnCreatedAttr, null);
            }
            Long expiresTolerance = 0L;
            String expiresToleranceAttr = attrs.getValue("", "expiresTolerance");
            if (expiresToleranceAttr != null) {
                expiresTolerance = (Long)SimpleTypeBindings.unmarshal((String)"long", (String)expiresToleranceAttr, null);
            }
            Boolean warnExpires = true;
            String warnExpiresAttr = attrs.getValue("", "warnExpires");
            if (warnExpiresAttr != null) {
                warnExpires = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)warnExpiresAttr, null);
            }
            return new TimestampVerification(createdTolerance, warnCreated, expiresTolerance, warnExpires);
        }
        if ("security-domain".equals(localName)) {
            String jndi = attrs.getValue("", "jndi");
            String authToken = attrs.getValue("", "authToken");
            String useSecurityDomainAliasesAttr = attrs.getValue("", "useSecurityDomainAliases");
            Boolean useSecurityDomainAliases = new Boolean(true);
            if (useSecurityDomainAliasesAttr != null) {
                useSecurityDomainAliases = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)useSecurityDomainAliasesAttr, null);
            }
            return new SecurityDomain(jndi, authToken, useSecurityDomainAliases);
        }
        return null;
    }

    public Object newChild(HashMap passwords, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("key-password".equals(localName)) {
            String alias = attrs.getValue("", "alias");
            String pwd = attrs.getValue("", "password");
            passwords.put(alias, pwd);
        }
        return null;
    }

    public void addChild(WSSecurityConfiguration configuration, Config defaultConfig, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + defaultConfig + "]"));
        configuration.setDefaultConfig(defaultConfig);
    }

    public void addChild(WSSecurityConfiguration configuration, Port port, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + port + "]"));
        configuration.addPort(port);
    }

    public void addChild(WSSecurityConfiguration configuration, TimestampVerification timestampVerification, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + timestampVerification + "]"));
        configuration.setTimestampVerification(timestampVerification);
    }

    public void addChild(WSSecurityConfiguration configuration, SecurityDomain securityDomain, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + securityDomain + "]"));
        configuration.setSecurityDomain(securityDomain);
    }

    public Object newChild(Config config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("sign".equals(localName)) {
            boolean includeTimestamp = true;
            String value = attrs.getValue("", "includeTimestamp");
            if (value != null) {
                includeTimestamp = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)value, null);
            }
            boolean includeFaults = false;
            value = attrs.getValue("", "includeFaults");
            if (value != null) {
                includeFaults = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)value, null);
            }
            return new Sign(attrs.getValue("", "type"), attrs.getValue("", "alias"), includeTimestamp, attrs.getValue("", "tokenReference"), attrs.getValue("", "securityDomainAliasLabel"), includeFaults);
        }
        if ("encrypt".equals(localName)) {
            boolean includeFaults = false;
            String value = attrs.getValue("", "includeFaults");
            if (value != null) {
                includeFaults = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)value, null);
            }
            return new Encrypt(attrs.getValue("", "type"), attrs.getValue("", "alias"), attrs.getValue("", "algorithm"), attrs.getValue("", "keyWrapAlgorithm"), attrs.getValue("", "tokenReference"), attrs.getValue("", "securityDomainAliasLabel"), includeFaults);
        }
        if ("timestamp".equals(localName)) {
            return new Timestamp(attrs.getValue("", "ttl"));
        }
        if ("requires".equals(localName)) {
            return new Requires();
        }
        if ("username".equals(localName)) {
            Boolean digestPassword = false;
            String digestPasswordAttr = attrs.getValue("", "digestPassword");
            if (digestPasswordAttr != null) {
                digestPassword = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)digestPasswordAttr, null);
            }
            Boolean useNonce = true;
            String useNonceAttr = attrs.getValue("", "useNonce");
            if (useNonceAttr != null) {
                useNonce = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)useNonceAttr, null);
            }
            Boolean useCreated = true;
            String useCreatedAttr = attrs.getValue("", "useCreated");
            if (useCreatedAttr != null) {
                useCreated = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)useCreatedAttr, null);
            }
            return new Username(digestPassword, useNonce, useCreated);
        }
        if ("authenticate".equals(localName)) {
            return new Authenticate();
        }
        if ("authorize".equals(localName)) {
            return new Authorize();
        }
        return null;
    }

    public void addChild(Config config, Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + encrypt + "]"));
        config.setEncrypt(encrypt);
    }

    public void addChild(Config config, Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + sign + "]"));
        config.setSign(sign);
    }

    public void addChild(Config config, Timestamp timestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + timestamp + "]"));
        config.setTimestamp(timestamp);
    }

    public void addChild(Config config, Username username, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + username + "]"));
        config.setUsername(username);
    }

    public void addChild(Config config, Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + requires + "]"));
        config.setRequires(requires);
    }

    public void addChild(Config config, Authenticate authenticate, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + authenticate + "]"));
        config.setAuthenticate(authenticate);
    }

    public void addChild(Authenticate authenticate, UsernameAuth usernameAuth, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + authenticate + ",child=" + usernameAuth + "]"));
        authenticate.setUsernameAuth(usernameAuth);
    }

    public void addChild(Authenticate authenticate, SignatureCertAuth signatureCertAuth, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + authenticate + ",child=" + signatureCertAuth + "]"));
        authenticate.setSignatureCertAuth(signatureCertAuth);
    }

    public void addChild(Config config, Authorize authorize, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + authorize + "]"));
        config.setAuthorize(authorize);
    }

    public void addChild(Authorize authorize, Unchecked unchecked, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + authorize + ",child=" + unchecked + "]"));
        authorize.setUnchecked(unchecked);
    }

    public void addChild(Authorize authorize, Role role, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + authorize + ",child=" + role + "]"));
        authorize.addRole(role);
    }

    private Object handleTargets(Object object, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("target".equals(localName)) {
            Target target = new Target(attrs.getValue("", "type"));
            if ("true".equals(attrs.getValue("", "contentOnly"))) {
                target.setContentOnly(true);
            }
            return target;
        }
        return null;
    }

    public Object newChild(Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(encrypt, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(sign, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("signature".equals(localName)) {
            boolean includeFaults = false;
            String value = attrs.getValue("", "includeFaults");
            if (value != null) {
                includeFaults = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)value, null);
            }
            return new RequireSignature(includeFaults);
        }
        if ("encryption".equals(localName)) {
            boolean includeFaults = false;
            String value = attrs.getValue("", "includeFaults");
            if (value != null) {
                includeFaults = (Boolean)SimpleTypeBindings.unmarshal((String)"boolean", (String)value, null);
            }
            return new RequireEncryption(includeFaults);
        }
        if ("timestamp".equals(localName)) {
            return new RequireTimestamp(attrs.getValue("", "maxAge"));
        }
        return null;
    }

    public Object newChild(Authenticate authenticate, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("usernameAuth".equals(localName)) {
            return new UsernameAuth();
        }
        if ("signatureCertAuth".equals(localName)) {
            return new SignatureCertAuth(attrs.getValue("", "certificatePrincipal"));
        }
        return null;
    }

    public Object newChild(Authorize authorize, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("unchecked".equals(localName)) {
            return new Unchecked();
        }
        if ("role".equals(localName)) {
            return new Role();
        }
        return null;
    }

    public Object newChild(RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireSignature, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireEncryption, navigator, namespaceURI, localName, attrs);
    }

    public void setValue(Target target, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + target + ",value=" + value + "]"));
        target.setValue(value);
    }

    public void setValue(Role role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + role + ",value=" + value + "]"));
        role.setName(value);
    }

    public void addChild(Encrypt encrypt, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + encrypt + ",child=" + target + "]"));
        encrypt.addTarget(target);
    }

    public void addChild(Sign sign, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + sign + ",child=" + target + "]"));
        sign.addTarget(target);
    }

    public void addChild(Requires requires, RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireEncryption + "]"));
        requires.setRequireEncryption(requireEncryption);
    }

    public void addChild(Requires requires, RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireSignature + "]"));
        requires.setRequireSignature(requireSignature);
    }

    public void addChild(Requires requires, RequireTimestamp requireTimestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireTimestamp + "]"));
        requires.setRequireTimestamp(requireTimestamp);
    }

    public void addChild(RequireEncryption requireEncryption, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireEncryption + ",child=" + target + "]"));
        requireEncryption.addTarget(target);
    }

    public void addChild(RequireSignature requireSignature, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireSignature + ",child=" + target + "]"));
        requireSignature.addTarget(target);
    }

    public Object newChild(Port port, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("operation".equals(localName)) {
            return new Operation(attrs.getValue("", "name"));
        }
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Port port, Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + operation + "]"));
        port.addOperation(operation);
    }

    public void addChild(Port port, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + config + "]"));
        port.setDefaultConfig(config);
    }

    public Object newChild(Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Operation operation, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + operation + ",child=" + config + "]"));
        operation.setConfig(config);
    }

    static {
        options.put("security-domain", "setSecurityDomain");
        options.put("key-store-file", "setKeyStoreFile");
        options.put("key-store-type", "setKeyStoreType");
        options.put("key-store-password", "setKeyStorePassword");
        options.put("trust-store-file", "setTrustStoreFile");
        options.put("trust-store-type", "setTrustStoreType");
        options.put("trust-store-password", "setTrustStorePassword");
        options.put("nonce-factory-class", "setNonceFactory");
        log = Logger.getLogger(WSSecurityOMFactory.class);
    }
}

