/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.io.File;
import java.io.FileFilter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.CompressionType;
import org.jboss.as.jdr.JdrLogger;
import org.jboss.as.jdr.JdrMessages;
import org.jboss.as.jdr.ModelControllerClientProxy;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.util.PythonInterpreter;

public class SoSReport {
    PyObject sosreport;
    PyObject sysPath;
    PythonInterpreter interpreter;
    private static final String SET_OPTION = "set_option";
    private static final String SET_GLOBAL = "set_global_plugin_option";

    public SoSReport(PythonInterpreter interpreter, String pyLocation, String jbossHomeDir) {
        this.interpreter = interpreter;
        interpreter.exec("from sys import path");
        this.sysPath = interpreter.get("path");
        this.addToJythonPath(pyLocation);
        this.setI18NJar(pyLocation);
        interpreter.exec("from sos.sosreport import SoSReport");
        interpreter.exec("reporter = SoSReport([])");
        this.sosreport = interpreter.get("reporter");
        String contribPath = this.determineContribLocation(pyLocation);
        this.addContribScriptsToPath(contribPath);
        this.enableOption("--batch");
        this.enableOption("--report");
        this.enableOption("--silent");
        this.setHome(jbossHomeDir);
    }

    private void setI18NJar(String pyLocation) {
        this.interpreter.exec("import sos");
        PyObject sos = this.interpreter.get("sos");
        sos.invoke("set_i18n", (PyObject)new PyString(pyLocation));
    }

    private void addToJythonPath(String location) {
        this.sysPath.invoke("append", (PyObject)new PyString(location));
    }

    private String determineContribLocation(String pyLocation) {
        int lastSeparatorIndex = pyLocation.lastIndexOf(File.separator);
        String contribLocation = pyLocation.substring(0, lastSeparatorIndex + 1) + "contrib";
        JdrLogger.ROOT_LOGGER.debug("JDR plugin contrib directory location: " + contribLocation);
        return contribLocation;
    }

    private void addContribScriptsToPath(String contrib) {
        this.addToJythonPath(contrib);
        this.interpreter.exec("import sos.plugins");
        this.interpreter.exec("sos_path = sos.plugins.__path__");
        PyObject sosModulePath = this.interpreter.get("sos_path");
        sosModulePath.invoke("append", (PyObject)new PyString(contrib));
        this.addJarsToJythonPath(sosModulePath, contrib);
    }

    private void addJarsToJythonPath(PyObject sosModulePath, String contribPath) {
        File contrib = new File(contribPath);
        if (!contrib.exists()) {
            JdrLogger.ROOT_LOGGER.debug("No plugin contrib directory found");
        } else if (!contrib.isDirectory()) {
            JdrLogger.ROOT_LOGGER.contribNotADirectory();
        } else {
            File[] jarFiles = contrib.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip");
                }
            });
            for (int i = 0; i < jarFiles.length; ++i) {
                String jarFile = jarFiles[i].getPath();
                JdrLogger.ROOT_LOGGER.debug("Adding plugin contrib jar file to jython path: " + jarFile);
                sosModulePath.invoke("append", (PyObject)new PyString(jarFile));
            }
        }
    }

    public String execute() {
        return this.sosreport.invoke("execute").asString();
    }

    public void setOption(String name, String value) {
        this.sosreport.invoke(SET_OPTION, (PyObject)new PyString(name), (PyObject)new PyString(value));
    }

    public void enableOption(String name) {
        this.sosreport.invoke(SET_OPTION, (PyObject)new PyString(name));
    }

    public void setGlobal(String name, Object value) {
        if (value != null) {
            ClassicPyObjectAdapter adapter = new ClassicPyObjectAdapter();
            this.sosreport.invoke(SET_GLOBAL, (PyObject)new PyString(name), adapter.adapt(value));
        }
    }

    public void setCompressionType(CompressionType type) {
        this.setOption("--compression-type", type.toString());
    }

    public void setControllerClient(ModelControllerClient controllerClient) {
        if (controllerClient == null) {
            throw JdrMessages.MESSAGES.varNull("controllerClient");
        }
        this.setGlobal("controller_client_proxy", new ModelControllerClientProxy(controllerClient));
    }

    public void setTmpDir(String tmpDir) {
        this.setOption("--tmp-dir", tmpDir);
    }

    public void setUsername(String username) {
        this.setGlobal("as7_user", username);
    }

    public void setPassword(String password) {
        this.setGlobal("as7_pass", password);
    }

    public void setHostname(String hostname) {
        this.setGlobal("as7_host", hostname);
    }

    public void setPort(String port) {
        this.setGlobal("as7_port", port);
    }

    public void setHome(String homeDir) {
        this.setGlobal("as7_home", homeDir);
    }

    public void setHostControllerName(String hostControllerName) {
        this.setGlobal("as7_host_controller_name", hostControllerName);
    }

    public void setServerName(String serverName) {
        this.setGlobal("as7_server_name", serverName);
    }
}

