/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.mgmt;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.controller.ModelUpdateResponse;
import org.jboss.as.domain.controller.ServerManagerClient;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class RemoteDomainControllerClient
implements ServerManagerClient {
    private final String id;
    private final InetAddress address;
    private final int port;
    private final ScheduledExecutorService executorService;
    private final ThreadFactory threadFactory;

    public RemoteDomainControllerClient(String id, InetAddress address, int port, ScheduledExecutorService executorService, ThreadFactory threadFactory) {
        this.id = id;
        this.address = address;
        this.port = port;
        this.executorService = executorService;
        this.threadFactory = threadFactory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void updateDomainModel(DomainModel domain) {
        try {
            new UpdateFullDomainRequest(domain).execute(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update domain", e);
        }
    }

    @Override
    public List<HostUpdateResult<?>> updateHostModel(List<AbstractHostModelUpdate<?>> updates) {
        try {
            return (List)new UpdateHostModelRequest(updates).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to update host model", (Throwable)e);
        }
    }

    @Override
    public List<ModelUpdateResponse<List<ServerIdentity>>> updateDomainModel(List<AbstractDomainModelUpdate<?>> updates) {
        try {
            return (List)new UpdateDomainModelRequest(updates).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to update domain model", (Throwable)e);
        }
    }

    @Override
    public List<UpdateResultHandlerResponse<?>> updateServerModel(String serverName, List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        try {
            return (List)new UpdateServerModelRequest(updates, serverName, allowOverallRollback).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to update domain model", (Throwable)e);
        }
    }

    @Override
    public boolean isActive() {
        try {
            return (Boolean)new IsActiveRequest().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public HostModel getHostModel() {
        try {
            return (HostModel)new GetHostModelRequest().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ServerModel getServerModel(String serverName) {
        try {
            return (ServerModel)new GetServerModelRequest(serverName).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        try {
            return (Map)new GetServerStatusesRequest().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ServerStatus restartServer(String serverName, long gracefulTimeout) {
        try {
            return (ServerStatus)new RestartServerRequest(serverName, gracefulTimeout).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return ServerStatus.UNKNOWN;
        }
    }

    @Override
    public ServerStatus startServer(String serverName) {
        try {
            return (ServerStatus)new StartServerRequest(serverName).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return ServerStatus.UNKNOWN;
        }
    }

    @Override
    public ServerStatus stopServer(String serverName, long gracefulTimeout) {
        try {
            return (ServerStatus)new StopServerRequest(serverName, gracefulTimeout).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return ServerStatus.UNKNOWN;
        }
    }

    public String toString() {
        return "RemoteDomainControllerClient{id='" + this.id + '\'' + ", address=" + this.address + ", port=" + this.port + '}';
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private ManagementRequestConnectionStrategy getConnectionStrategy() {
        return new ManagementRequestConnectionStrategy.EstablishConnectingStrategy(this.address, this.port, 10L, (ExecutorService)this.executorService, this.threadFactory);
    }

    private abstract class ServerStatusChangeRequest
    extends ServerManagerRequest<ServerStatus> {
        private final String serverName;
        private final Long gracefulTimeout;

        private ServerStatusChangeRequest(String serverName, Long gracefulTimeout) {
            this.serverName = serverName;
            this.gracefulTimeout = gracefulTimeout;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(65);
            marshaller.writeUTF(this.serverName);
            if (this.gracefulTimeout != null) {
                marshaller.writeByte(97);
                marshaller.writeLong(this.gracefulTimeout.longValue());
            }
            marshaller.finish();
        }

        protected ServerStatus receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)85);
            ServerStatus response = (ServerStatus)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerStatus.class);
            unmarshaller.finish();
            return response;
        }
    }

    private class StopServerRequest
    extends ServerStatusChangeRequest {
        private StopServerRequest(String serverName, long gracefulTimeout) {
            super(serverName, gracefulTimeout);
        }

        public final byte getRequestCode() {
            return 96;
        }

        protected final byte getResponseCode() {
            return 98;
        }
    }

    private class RestartServerRequest
    extends ServerStatusChangeRequest {
        private RestartServerRequest(String serverName, long gracefulTimeout) {
            super(serverName, gracefulTimeout);
        }

        public final byte getRequestCode() {
            return 99;
        }

        protected final byte getResponseCode() {
            return 100;
        }
    }

    private class StartServerRequest
    extends ServerStatusChangeRequest {
        private StartServerRequest(String serverName) {
            super(serverName, null);
        }

        public final byte getRequestCode() {
            return 88;
        }

        protected final byte getResponseCode() {
            return 89;
        }
    }

    private class GetServerModelRequest
    extends ServerManagerRequest<ServerModel> {
        private final String serverName;

        private GetServerModelRequest(String serverName) {
            this.serverName = serverName;
        }

        public final byte getRequestCode() {
            return 72;
        }

        protected final byte getResponseCode() {
            return 80;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(65);
            marshaller.writeUTF(this.serverName);
            marshaller.finish();
        }

        protected ServerModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)73);
            ServerModel response = (ServerModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerModel.class);
            unmarshaller.finish();
            return response;
        }
    }

    private class GetServerStatusesRequest
    extends ServerManagerRequest<Map<ServerIdentity, ServerStatus>> {
        private GetServerStatusesRequest() {
        }

        public final byte getRequestCode() {
            return 81;
        }

        protected final byte getResponseCode() {
            return 87;
        }

        protected Map<ServerIdentity, ServerStatus> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)82);
            int count = unmarshaller.readInt();
            HashMap<ServerIdentity, ServerStatus> map = new HashMap<ServerIdentity, ServerStatus>();
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)83);
                String serverName = unmarshaller.readUTF();
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)84);
                String groupName = unmarshaller.readUTF();
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)85);
                ServerStatus status = (ServerStatus)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerStatus.class);
                map.put(new ServerIdentity(RemoteDomainControllerClient.this.id, groupName, serverName), status);
            }
            return map;
        }
    }

    private class UpdateServerModelRequest
    extends ServerManagerRequest<List<UpdateResultHandlerResponse<?>>> {
        private final List<AbstractServerModelUpdate<?>> updates;
        private final String serverName;
        private final boolean allowOverallRollback;

        private UpdateServerModelRequest(List<AbstractServerModelUpdate<?>> updates, String serverName, boolean allowOverallRollback) {
            this.updates = updates;
            this.serverName = serverName;
            this.allowOverallRollback = allowOverallRollback;
        }

        public final byte getRequestCode() {
            return 64;
        }

        protected final byte getResponseCode() {
            return 69;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(65);
            marshaller.writeUTF(this.serverName);
            marshaller.writeByte(66);
            marshaller.writeBoolean(this.allowOverallRollback);
            marshaller.writeByte(67);
            marshaller.writeInt(this.updates.size());
            for (AbstractServerModelUpdate<?> update : this.updates) {
                marshaller.writeByte(68);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected List<UpdateResultHandlerResponse<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)49);
            int responseCount = unmarshaller.readInt();
            if (responseCount != this.updates.size()) {
                throw new IOException("Invalid host model update response.  Response count not equal to update count.");
            }
            ArrayList responses = new ArrayList(responseCount);
            for (int i = 0; i < responseCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)50);
                UpdateResultHandlerResponse response = (UpdateResultHandlerResponse)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, UpdateResultHandlerResponse.class);
                responses.add(response);
            }
            unmarshaller.finish();
            return responses;
        }
    }

    private class UpdateHostModelRequest
    extends ServerManagerRequest<List<HostUpdateResult<?>>> {
        private final List<AbstractHostModelUpdate<?>> updates;

        private UpdateHostModelRequest(List<AbstractHostModelUpdate<?>> updates) {
            this.updates = updates;
        }

        public final byte getRequestCode() {
            return 52;
        }

        protected final byte getResponseCode() {
            return 55;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(53);
            marshaller.writeInt(this.updates.size());
            for (AbstractHostModelUpdate<?> update : this.updates) {
                marshaller.writeByte(54);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected List<HostUpdateResult<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)49);
            int responseCount = unmarshaller.readInt();
            if (responseCount != this.updates.size()) {
                throw new IOException("Invalid host model update response.  Response count not equal to update count.");
            }
            ArrayList responses = new ArrayList(responseCount);
            for (int i = 0; i < responseCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)50);
                HostUpdateResult response = (HostUpdateResult)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, HostUpdateResult.class);
                responses.add(response);
            }
            unmarshaller.finish();
            return responses;
        }
    }

    private class UpdateDomainModelRequest
    extends ServerManagerRequest<List<ModelUpdateResponse<List<ServerIdentity>>>> {
        private final List<AbstractDomainModelUpdate<?>> updates;

        private UpdateDomainModelRequest(List<AbstractDomainModelUpdate<?>> updates) {
            this.updates = updates;
        }

        public final byte getRequestCode() {
            return 40;
        }

        protected final byte getResponseCode() {
            return 51;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(41);
            marshaller.writeInt(this.updates.size());
            for (AbstractDomainModelUpdate<?> update : this.updates) {
                marshaller.writeByte(48);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected List<ModelUpdateResponse<List<ServerIdentity>>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)49);
            int responseCount = unmarshaller.readInt();
            if (responseCount != this.updates.size()) {
                throw new IOException("Invalid domain model update response.  Response count not equal to update count.");
            }
            ArrayList<ModelUpdateResponse<List<ServerIdentity>>> responses = new ArrayList<ModelUpdateResponse<List<ServerIdentity>>>(responseCount);
            for (int i = 0; i < responseCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)50);
                ModelUpdateResponse response = (ModelUpdateResponse)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ModelUpdateResponse.class);
                responses.add(response);
            }
            unmarshaller.finish();
            return responses;
        }
    }

    private class IsActiveRequest
    extends ServerManagerRequest<Boolean> {
        private IsActiveRequest() {
        }

        public final byte getRequestCode() {
            return 56;
        }

        protected final byte getResponseCode() {
            return 57;
        }

        protected Boolean receiveResponse(InputStream input) throws IOException {
            return true;
        }
    }

    private class UpdateFullDomainRequest
    extends ServerManagerRequest<Void> {
        private final DomainModel domainModel;

        private UpdateFullDomainRequest(DomainModel domainModel) {
            this.domainModel = domainModel;
        }

        public final byte getRequestCode() {
            return 38;
        }

        protected final byte getResponseCode() {
            return 39;
        }

        protected final void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            Marshaller marshaller = RemoteDomainControllerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(19);
            marshaller.writeObject((Object)this.domainModel);
            marshaller.finish();
        }
    }

    private class GetHostModelRequest
    extends ServerManagerRequest<HostModel> {
        private GetHostModelRequest() {
        }

        public final byte getRequestCode() {
            return 70;
        }

        protected final byte getResponseCode() {
            return 71;
        }

        protected HostModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            HostModel hm = (HostModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, HostModel.class);
            unmarshaller.finish();
            return hm;
        }
    }

    private abstract class ServerManagerRequest<T>
    extends ManagementRequest<T> {
        private ServerManagerRequest() {
        }

        protected byte getHandlerId() {
            return 37;
        }
    }
}

