/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final FileRepository fileRepository;

    static final ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("hash").set(state.get("hash"));
        op.get("enabled").set(state.get("enabled"));
        return op;
    }

    public ServerGroupDeploymentAddHandler(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        ModelNode deployment = context.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        byte[] hash = deployment.require("hash").asBytes();
        this.fileRepository.getDeploymentFiles(hash);
        ModelNode subModel = context.getSubModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(deployment.get("runtime-name").asString());
        subModel.get("hash").set(hash);
        subModel.get("enabled").set(operation.has("enabled") && operation.get("enabled").asBoolean());
        resultHandler.handleResultComplete();
        return new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.get("address")));
    }
}

