/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.AbstractServerUpdateTask;
import org.jboss.as.domain.controller.plan.ServerOperationExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.dmr.ModelNode;

class ServerRestartTask
extends AbstractServerUpdateTask {
    private final ServerOperationExecutor serverOperationExecutor;
    private final long gracefulTimeout;

    ServerRestartTask(ServerOperationExecutor serverOperationExecutor, ServerIdentity serverId, ServerUpdatePolicy updatePolicy, AbstractServerUpdateTask.ServerUpdateResultHandler resultHandler, long gracefulTimeout) {
        super(serverId, updatePolicy, resultHandler);
        this.serverOperationExecutor = serverOperationExecutor;
        this.gracefulTimeout = gracefulTimeout;
    }

    @Override
    protected void processUpdates() {
        ModelNode restartOp = this.getRestartOp();
        ModelNode rsp = this.serverOperationExecutor.executeServerOperation(this.serverId, OperationBuilder.Factory.create((ModelNode)restartOp).build());
        this.updatePolicy.recordServerResult(this.serverId, rsp);
        this.resultHandler.handleServerUpdateResult(this.serverId, rsp);
    }

    private ModelNode getRestartOp() {
        ModelNode address = new ModelNode();
        address.add("host", this.serverId.getHostName());
        ModelNode op = Util.getEmptyOperation((String)"restart-server", (ModelNode)address);
        op.get("server").set(this.serverId.getServerName());
        op.get("graceful-timeout").set(this.gracefulTimeout);
        return op;
    }
}

