/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.descriptions;

import java.util.Locale;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.as.controller.descriptions.common.ProfileDescription;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.domain.controller.descriptions.ServerGroupDescription;
import org.jboss.dmr.ModelNode;

public final class DomainDescriptionProviders {
    public static final DescriptionProvider ROOT_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DomainRootDescription.getDescription(locale);
        }
    };
    public static final DescriptionProvider PROFILE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return ProfileDescription.getProfileDescription((Locale)locale);
        }
    };
    public static final DescriptionProvider SOCKET_BINDING_GROUP = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return SocketBindingGroupDescription.getDomainSocketBindingGroupDescription((Locale)locale);
        }
    };
    public static final DescriptionProvider SOCKET_BINDING = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return SocketBindingGroupDescription.getSocketBindingDescription((Locale)locale);
        }
    };
    public static final DescriptionProvider PATH_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return PathDescription.getNamedPathDescription((Locale)locale);
        }
    };
    public static final DescriptionProvider SERVER_GROUP = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return ServerGroupDescription.getServerGroupDescription(locale);
        }
    };
    public static final DescriptionProvider SERVER_GROUP_DEPLOYMENT = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DeploymentDescription.getDeploymentDescription((Locale)locale, (boolean)true);
        }
    };

    private DomainDescriptionProviders() {
    }
}

