/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.dmr.ModelNode;

public class ReadChildrenNamesHandler
extends GlobalOperationHandlers.ReadChildrenNamesOperationHandler {
    private final DomainModelImpl domainModelImpl;

    public ReadChildrenNamesHandler(DomainModelImpl domainModelImpl) {
        this.domainModelImpl = domainModelImpl;
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        String childName;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        if (address.size() == 0 && this.domainModelImpl.isMaster() && "host".equals(childName = operation.require("child-type").asString())) {
            ModelNode result = new ModelNode().setEmptyList();
            for (String hostName : this.domainModelImpl.getHostNames()) {
                result.add(hostName);
            }
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
        return super.execute(context, operation, resultHandler);
    }
}

