/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingRemoveHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.descriptions.DomainDescriptionProviders;
import org.jboss.as.domain.controller.operations.ProfileAddHandler;
import org.jboss.as.domain.controller.operations.ProfileDescribeHandler;
import org.jboss.as.domain.controller.operations.ProfileRemoveHandler;
import org.jboss.as.domain.controller.operations.ReadChildrenNamesHandler;
import org.jboss.as.domain.controller.operations.ReadResourceHandler;
import org.jboss.as.domain.controller.operations.ServerGroupAddHandler;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupAddHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.SystemPropertyAddHandler;
import org.jboss.as.domain.controller.operations.SystemPropertyRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadURLHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentDeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRedeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentUndeployHandler;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.operations.ExtensionAddHandler;
import org.jboss.as.server.operations.ExtensionRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class DomainModelUtil {
    DomainModelUtil() {
    }

    static ModelNode createBaseModel() {
        ModelNode baseModel = new ModelNode();
        baseModel.get("host");
        return baseModel;
    }

    static void updateCoreModel(ModelNode rootModel) {
        rootModel.get("namespaces").setEmptyList();
        rootModel.get("schema-locations").setEmptyList();
        rootModel.get("extension");
        rootModel.get("path");
        rootModel.get("profile");
        rootModel.get("interface");
        rootModel.get("socket-binding-group");
        rootModel.get("system-properties").setEmptyObject();
        rootModel.get("deployment");
        rootModel.get("server-group");
        rootModel.get("host");
    }

    static ExtensionContext initializeMasterDomainRegistry(ModelNodeRegistration root, ExtensibleConfigurationPersister configurationPersister, DeploymentRepository deploymentRepo, FileRepository fileRepository, DomainModelImpl model) {
        return DomainModelUtil.initializeDomainRegistry(root, configurationPersister, deploymentRepo, fileRepository, true, model);
    }

    static ExtensionContext initializeSlaveDomainRegistry(ModelNodeRegistration root, ExtensibleConfigurationPersister configurationPersister, DeploymentRepository deploymentRepo, FileRepository fileRepository, DomainModelImpl model) {
        return DomainModelUtil.initializeDomainRegistry(root, configurationPersister, deploymentRepo, fileRepository, false, model);
    }

    private static ExtensionContext initializeDomainRegistry(ModelNodeRegistration root, ExtensibleConfigurationPersister configurationPersister, DeploymentRepository deploymentRepo, FileRepository fileRepository, boolean isMaster, DomainModelImpl model) {
        root.registerOperationHandler("resolve-address", (OperationHandler)GlobalOperationHandlers.RESOLVE, (DescriptionProvider)GlobalOperationHandlers.RESOLVE, false, OperationEntry.EntryType.PRIVATE);
        root.registerOperationHandler("read-resource", (OperationHandler)new ReadResourceHandler(model), CommonProviders.READ_RESOURCE_PROVIDER, true);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("read-resource-description", (OperationHandler)GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
        root.registerOperationHandler("read-children-names", (OperationHandler)new ReadChildrenNamesHandler(model), CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-children-types", (OperationHandler)GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
        root.registerOperationHandler("read-children-resources", (OperationHandler)new GlobalOperationHandlers.ReadChildrenResourcesOperationHandler(), CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-operation-names", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-operation-description", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("add-namespace", (OperationHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-system-property", (OperationHandler)SystemPropertyAddHandler.INSTANCE, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-system-property", (OperationHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        DeploymentUploadBytesHandler dubh = new DeploymentUploadBytesHandler((DeploymentRepository)(isMaster ? deploymentRepo : null));
        root.registerOperationHandler("upload-deployment-bytes", (OperationHandler)dubh, (DescriptionProvider)dubh);
        DeploymentUploadURLHandler duuh = new DeploymentUploadURLHandler((DeploymentRepository)(isMaster ? deploymentRepo : null));
        root.registerOperationHandler("upload-deployment-url", (OperationHandler)duuh, (DescriptionProvider)duuh);
        DeploymentUploadStreamAttachmentHandler dush = new DeploymentUploadStreamAttachmentHandler((DeploymentRepository)(isMaster ? deploymentRepo : null));
        root.registerOperationHandler("upload-deployment-stream", (OperationHandler)dush, (DescriptionProvider)dush);
        DeploymentFullReplaceHandler dfrh = new DeploymentFullReplaceHandler(deploymentRepo, isMaster);
        root.registerOperationHandler("full-replace-deployment", (OperationHandler)dfrh, (DescriptionProvider)dfrh);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("delete-snapshot", (OperationHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("list-snapshots", (OperationHandler)snapshotList, (DescriptionProvider)snapshotList, false);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("take-snapshot", (OperationHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        ModelNodeRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.NAMED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationHandler)InterfaceAddHandler.NAMED_INSTANCE, (DescriptionProvider)InterfaceAddHandler.NAMED_INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationHandler)InterfaceAddHandler.NAMED_INSTANCE, (DescriptionProvider)InterfaceAddHandler.NAMED_INSTANCE, false);
        ModelNodeRegistration profile = root.registerSubModel(PathElement.pathElement((String)"profile"), DomainDescriptionProviders.PROFILE);
        profile.registerOperationHandler("add", (OperationHandler)ProfileAddHandler.INSTANCE, (DescriptionProvider)ProfileAddHandler.INSTANCE, false);
        profile.registerOperationHandler("remove", (OperationHandler)ProfileRemoveHandler.INSTANCE, (DescriptionProvider)ProfileRemoveHandler.INSTANCE, false);
        profile.registerOperationHandler("describe", (OperationHandler)ProfileDescribeHandler.INSTANCE, (DescriptionProvider)ProfileDescribeHandler.INSTANCE, false);
        ModelNodeRegistration paths = root.registerSubModel(PathElement.pathElement((String)"path"), DomainDescriptionProviders.PATH_DESCRIPTION);
        paths.registerOperationHandler("add", (OperationHandler)PathAddHandler.NAMED_INSTANCE, (DescriptionProvider)PathAddHandler.NAMED_INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ModelNodeRegistration socketBindingGroup = root.registerSubModel(PathElement.pathElement((String)"socket-binding-group"), DomainDescriptionProviders.SOCKET_BINDING_GROUP);
        socketBindingGroup.registerOperationHandler("add", (OperationHandler)SocketBindingGroupAddHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupAddHandler.INSTANCE, false);
        socketBindingGroup.registerOperationHandler("remove", (OperationHandler)SocketBindingGroupRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupRemoveHandler.INSTANCE, false);
        socketBindingGroup.registerReadWriteAttribute("port-offset", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindingGroup.registerReadWriteAttribute("default-interface", null, (OperationHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, false, true), AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration socketBindings = socketBindingGroup.registerSubModel(PathElement.pathElement((String)"socket-binding"), DomainDescriptionProviders.SOCKET_BINDING);
        socketBindings.registerOperationHandler("add", (OperationHandler)SocketBindingAddHandler.INSTANCE, (DescriptionProvider)SocketBindingAddHandler.INSTANCE, false);
        socketBindings.registerOperationHandler("remove", (OperationHandler)SocketBindingRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingRemoveHandler.INSTANCE, false);
        socketBindings.registerReadWriteAttribute("interface", null, (OperationHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("port", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, false, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("fixed-port", null, (OperationHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("multicast-address", null, (OperationHandler)new WriteAttributeHandlers.InetAddressValidatingHandler(true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("multicast-port", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, true, true), AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration serverGroups = root.registerSubModel(PathElement.pathElement((String)"server-group"), DomainDescriptionProviders.SERVER_GROUP);
        serverGroups.registerOperationHandler("add", (OperationHandler)ServerGroupAddHandler.INSTANCE, (DescriptionProvider)ServerGroupAddHandler.INSTANCE, false);
        serverGroups.registerOperationHandler("remove", (OperationHandler)ServerGroupRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupRemoveHandler.INSTANCE, false);
        serverGroups.registerReadWriteAttribute("socket-binding-group", null, WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverGroups.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        serverGroups.registerOperationHandler("add-system-property", (OperationHandler)SystemPropertyAddHandler.INSTANCE, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE, false);
        serverGroups.registerOperationHandler("remove-system-property", (OperationHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        ModelNodeRegistration groupVMs = serverGroups.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ModelNodeRegistration)groupVMs);
        ModelNodeRegistration serverGroupDeployments = serverGroups.registerSubModel(PathElement.pathElement((String)"deployment"), DomainDescriptionProviders.SERVER_GROUP_DEPLOYMENT);
        ServerGroupDeploymentAddHandler sgdah = new ServerGroupDeploymentAddHandler(fileRepository);
        serverGroupDeployments.registerOperationHandler("add", (OperationHandler)sgdah, (DescriptionProvider)sgdah);
        ServerGroupDeploymentReplaceHandler sgdrh = new ServerGroupDeploymentReplaceHandler(fileRepository);
        serverGroupDeployments.registerOperationHandler("replace-deployment", (OperationHandler)sgdrh, (DescriptionProvider)sgdrh);
        serverGroupDeployments.registerOperationHandler("deploy", (OperationHandler)ServerGroupDeploymentDeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentDeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("redeploy", (OperationHandler)ServerGroupDeploymentRedeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRedeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("undeploy", (OperationHandler)ServerGroupDeploymentUndeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentUndeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("remove", (OperationHandler)ServerGroupDeploymentRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRemoveHandler.INSTANCE);
        ModelNodeRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = new DeploymentAddHandler(deploymentRepo, isMaster);
        deployments.registerOperationHandler("add", (OperationHandler)dah, (DescriptionProvider)dah);
        deployments.registerOperationHandler("remove", (OperationHandler)DeploymentRemoveHandler.INSTANCE, (DescriptionProvider)DeploymentRemoveHandler.INSTANCE);
        ModelNodeRegistration extensions = root.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(profile, deployments, (SubsystemXmlWriterRegistry)configurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
        return extensionContext;
    }
}

