/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.ArrayList;
import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.dmr.ModelNode;

public class DeploymentRemoveHandler
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final DeploymentRemoveHandler INSTANCE = new DeploymentRemoveHandler();

    private DeploymentRemoveHandler() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String deploymentName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        Resource root = context.getRootResource();
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            ArrayList<String> badGroups = new ArrayList<String>();
            for (Resource.ResourceEntry entry : root.getChildren("server-group")) {
                if (!entry.hasChild(PathElement.pathElement((String)"deployment", (String)deploymentName))) continue;
                badGroups.add(entry.getName());
            }
            if (badGroups.size() > 0) {
                String msg = String.format("Cannot remove deployment %s from the domain as it is still used by server groups %s", deploymentName, badGroups);
                throw new OperationFailedException(new ModelNode().set(msg));
            }
        }
        super.performRemove(context, operation, model);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DomainRootDescription.getDeploymentRemoveOperation(locale);
    }
}

