/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class AddPropertiesUser {
    private static final String[] badUsernames = new String[]{"admin", "administrator", "root"};
    private static final String DEFAULT_REALM = "ManagementRealm";
    private Console theConsole = System.console();
    private List<File> propertiesFiles;
    private State nextState;

    private AddPropertiesUser() {
        if (this.theConsole == null) {
            throw new IllegalStateException("No console available.");
        }
        this.nextState = new PropertyFileFinder();
    }

    private AddPropertiesUser(String user, char[] password, String realm) {
        if (this.theConsole == null) {
            throw new IllegalStateException("No console available.");
        }
        Values values = new Values();
        values.nonInteractive = true;
        values.userName = user;
        Values.access$402(values, password);
        values.realm = realm;
        this.nextState = new PropertyFileFinder(values);
    }

    private AddPropertiesUser(String user, char[] password) {
        this(user, password, DEFAULT_REALM);
    }

    private void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            new AddPropertiesUser(args[0], args[1].toCharArray(), args[2]).run();
        } else if (args.length == 2) {
            new AddPropertiesUser(args[0], args[1].toCharArray()).run();
        } else {
            new AddPropertiesUser().run();
        }
    }

    private static interface State {
        public State execute();
    }

    private class Values {
        private boolean nonInteractive = false;
        private String realm;
        private String userName;
        private char[] password;

        private Values() {
        }

        static /* synthetic */ char[] access$402(Values x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }

    private class ErrorState
    implements State {
        private final State nextState;
        private final String errorMessage;

        private ErrorState(String errorMessage) {
            this(errorMessage, (State)null);
        }

        private ErrorState(String errorMessage, State nextState) {
            this.errorMessage = errorMessage;
            this.nextState = nextState;
        }

        @Override
        public State execute() {
            AddPropertiesUser.this.theConsole.printf("\n* Error * \n", new Object[0]);
            AddPropertiesUser.this.theConsole.printf("Unable to add user due to error '%s'\n\n", this.errorMessage);
            return this.nextState;
        }
    }

    private class AddUser
    implements State {
        private final Values values;

        private AddUser(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            String entry;
            try {
                String hash = new UsernamePasswordHashUtil().generateHashedHexURP(this.values.userName, this.values.realm, this.values.password);
                entry = this.values.userName + "=" + hash;
            }
            catch (NoSuchAlgorithmException e) {
                return new ErrorState(e.getMessage());
            }
            for (File current : AddPropertiesUser.this.propertiesFiles) {
                try {
                    this.append(entry, current);
                    AddPropertiesUser.this.theConsole.printf("Added user '%s' to file '%s'\n", this.values.userName, current.getCanonicalPath());
                }
                catch (IOException e) {
                    return new ErrorState("Unable to add user to " + current.getAbsolutePath() + " due to error " + e.getMessage());
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(String entry, File toFile) throws IOException {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fw = new FileWriter(toFile, true);
                bw = new BufferedWriter(fw);
                bw.append(entry);
                bw.newLine();
                this.safeClose(bw);
                this.safeClose(fw);
            }
            catch (Throwable throwable) {
                this.safeClose(bw);
                this.safeClose(fw);
                throw throwable;
            }
        }

        private void safeClose(Closeable c) {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class ConfirmNewUser
    implements State {
        private final Values values;

        private ConfirmNewUser(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            boolean yes;
            AddPropertiesUser.this.theConsole.printf("About to add user '%s' for realm '%s'\n", this.values.userName, this.values.realm);
            String temp = AddPropertiesUser.this.theConsole.readLine("Is this correct yes/no? ", new Object[0]);
            boolean bl = yes = temp != null && "yes".equals(temp.toLowerCase());
            if (!yes) {
                return new PromptNewUserState();
            }
            return new AddUser(this.values);
        }
    }

    private class WeakCheckState
    implements State {
        private Values values;

        private WeakCheckState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            if (Arrays.equals(this.values.userName.toCharArray(), this.values.password)) {
                if (this.values.nonInteractive) {
                    return new ErrorState("Username must not match the password");
                }
                return new ErrorState("Username must not match the password", new PromptNewUserState(this.values));
            }
            for (char currentChar : this.values.userName.toCharArray()) {
                if (Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
                if (this.values.nonInteractive) {
                    return new ErrorState("Only alpha/numeric usernames accepted.");
                }
                this.values.userName = null;
                return new ErrorState("Only alpha/numeric usernames accepted.", new PromptNewUserState(this.values));
            }
            boolean weakUserName = false;
            for (String current : badUsernames) {
                if (!current.equals(this.values.userName.toLowerCase())) continue;
                weakUserName = true;
                break;
            }
            if (weakUserName && !this.values.nonInteractive) {
                boolean yes;
                AddPropertiesUser.this.theConsole.printf("The username '%s' is easy to guess\n", this.values.userName);
                String temp = AddPropertiesUser.this.theConsole.readLine("Are you sure you want to add user '%s' yes/no? ", this.values.userName);
                boolean bl = yes = temp != null && "yes".equals(temp.toLowerCase());
                if (!yes) {
                    this.values.userName = null;
                    return new PromptNewUserState(this.values);
                }
            }
            if (this.values.nonInteractive) {
                return new AddUser(this.values);
            }
            return new ConfirmNewUser(this.values);
        }
    }

    private class PromptNewUserState
    implements State {
        private final Values values;

        PromptNewUserState() {
            this.values = new Values();
            this.values.realm = AddPropertiesUser.DEFAULT_REALM;
        }

        PromptNewUserState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            if (!this.values.nonInteractive) {
                AddPropertiesUser.this.theConsole.printf("\nEnter details of new user to add.\n", new Object[0]);
                String temp = AddPropertiesUser.this.theConsole.readLine("Realm (%s) : ", this.values.realm);
                if (temp == null) {
                    AddPropertiesUser.this.theConsole.printf("\n", new Object[0]);
                    return null;
                }
                if (temp.length() > 0) {
                    this.values.realm = temp;
                }
                if (this.values.userName == null) {
                    temp = AddPropertiesUser.this.theConsole.readLine("Username : ", new Object[0]);
                    if (temp == null || temp.length() == 0) {
                        AddPropertiesUser.this.theConsole.printf("\n", new Object[0]);
                        return null;
                    }
                    this.values.userName = temp;
                } else {
                    temp = AddPropertiesUser.this.theConsole.readLine("Username (%s): ", this.values.userName);
                    if (temp == null) {
                        AddPropertiesUser.this.theConsole.printf("\n", new Object[0]);
                        return null;
                    }
                    if (temp.length() > 0) {
                        this.values.userName = temp;
                    }
                }
                char[] tempChar = AddPropertiesUser.this.theConsole.readPassword("Password : ", new Object[0]);
                if (tempChar == null || tempChar.length == 0) {
                    AddPropertiesUser.this.theConsole.printf("\n", new Object[0]);
                    return null;
                }
                char[] secondTempChar = AddPropertiesUser.this.theConsole.readPassword("Re-enter Password : ", new Object[0]);
                if (tempChar == null || tempChar.length == 0) {
                    AddPropertiesUser.this.theConsole.printf("\n", new Object[0]);
                    return null;
                }
                if (!Arrays.equals(tempChar, secondTempChar)) {
                    return new ErrorState("Passwords to not match", this);
                }
                Values.access$402(this.values, tempChar);
            }
            return new WeakCheckState(this.values);
        }
    }

    private class PropertyFileFinder
    implements State {
        private final Values values;

        private PropertyFileFinder() {
            this.values = null;
        }

        private PropertyFileFinder(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            File domainProps;
            String jbossHome = System.getenv("JBOSS_HOME");
            if (jbossHome == null) {
                return new ErrorState("JBOSS_HOME environment variable not set.");
            }
            ArrayList<File> foundFiles = new ArrayList<File>(2);
            File standaloneProps = new File(jbossHome + "/standalone/configuration/mgmt-users.properties");
            if (standaloneProps.exists()) {
                foundFiles.add(standaloneProps);
            }
            if ((domainProps = new File(jbossHome + "/domain/configuration/mgmt-users.properties")).exists()) {
                foundFiles.add(domainProps);
            }
            if (foundFiles.size() == 0) {
                return new ErrorState("No mgmt-users.properties files found.");
            }
            AddPropertiesUser.this.propertiesFiles = foundFiles;
            if (this.values == null) {
                return new PromptNewUserState();
            }
            return new PromptNewUserState(this.values);
        }
    }
}

