/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.deployment.module.DeploymentModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;

public class DeploymentModuleLoaderImpl
extends DeploymentModuleLoader {
    private final ConcurrentMap<ModuleIdentifier, ModuleSpec> moduleSpecs = new ConcurrentHashMap<ModuleIdentifier, ModuleSpec>();

    @Override
    public void addModuleSpec(ModuleSpec moduleSpec) {
        if (this.moduleSpecs.putIfAbsent(moduleSpec.getModuleIdentifier(), moduleSpec) != null) {
            throw new IllegalArgumentException("Module spec has already been added for identifier [" + moduleSpec.getModuleIdentifier() + "]");
        }
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.getName().startsWith("deployment.")) {
            return super.preloadModule(identifier);
        }
        return Module.getModuleFromDefaultLoader((ModuleIdentifier)identifier);
    }

    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        ConcurrentMap<ModuleIdentifier, ModuleSpec> moduleSpecs = this.moduleSpecs;
        ModuleSpec moduleSpec = (ModuleSpec)moduleSpecs.get(moduleIdentifier);
        return moduleSpec;
    }

    @Override
    public void removeModule(Module module) {
        if (this.moduleSpecs.remove(module.getIdentifier()) == null) {
            throw new IllegalStateException("Unknown module " + module);
        }
        this.unloadModuleLocal(module);
    }

    public String toString() {
        return "as-deployment";
    }
}

