/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.vfs.VirtualFile;

public final class NestedMounts
implements Iterable<Entry> {
    public static AttachmentKey<NestedMounts> ATTACHMENT_KEY = new AttachmentKey<NestedMounts>(NestedMounts.class);
    private final List<Entry> mounts;

    public NestedMounts(int initialCapacity) {
        this.mounts = new ArrayList<Entry>(initialCapacity);
    }

    public Entry get(int i) {
        return this.mounts.get(i);
    }

    public void add(VirtualFile file, MountHandle mount) {
        this.mounts.add(new Entry(file, mount));
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.mounts.iterator();
    }

    public int size() {
        return this.mounts.size();
    }

    public Closeable[] getClosables() {
        int size = this.mounts.size();
        Closeable[] closables = new Closeable[size];
        for (int i = 0; i < size; ++i) {
            closables[i] = this.mounts.get(i).mount();
        }
        return closables;
    }

    public static final class Entry {
        private VirtualFile file;
        private MountHandle mount;

        public Entry(VirtualFile file, MountHandle mount) {
            this.file = file;
            this.mount = mount;
        }

        public VirtualFile file() {
            return this.file;
        }

        public MountHandle mount() {
            return this.mount;
        }
    }
}

