/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.naming;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.naming.DuplicateBindingException;
import org.jboss.as.deployment.naming.JndiName;
import org.jboss.as.deployment.unit.DeploymentUnitContext;

public class NamespaceBindings {
    public static final AttachmentKey<NamespaceBindings> ATTACHMENT_KEY = new AttachmentKey<NamespaceBindings>(NamespaceBindings.class);
    private final ConcurrentMap<JndiName, Object> bindings = new ConcurrentHashMap<JndiName, Object>();

    public static NamespaceBindings getNamespaceBindings(DeploymentUnitContext context) {
        NamespaceBindings namespaceBindings = context.getAttachment(ATTACHMENT_KEY);
        if (namespaceBindings == null) {
            namespaceBindings = new NamespaceBindings();
            context.putAttachment(ATTACHMENT_KEY, namespaceBindings);
        }
        return namespaceBindings;
    }

    public boolean addBinding(JndiName name, Object value) throws DuplicateBindingException {
        Object existing = this.bindings.putIfAbsent(name, value);
        if (existing != null && !existing.equals(value)) {
            StringBuilder builder = new StringBuilder("Duplicate JNDI bindings for '").append(name).append("' are not compatible.  [").append(existing).append("] != [").append(value).append("]");
            throw new DuplicateBindingException(builder.toString());
        }
        return existing == null;
    }
}

