/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainDeploymentRemove;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.NewRepositoryContentUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class DomainDeploymentAdd
extends AbstractDomainModelUpdate<Void>
implements NewRepositoryContentUpdate {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] hash;
    private final boolean start;

    public DomainDeploymentAdd(String uniqueName, String runtimeName, byte[] hash, boolean start) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException("runtimeName is null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("hash is null");
        }
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.hash = hash;
        this.start = start;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    public boolean isStart() {
        return this.start;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        DeploymentUnitElement due = new DeploymentUnitElement(this.uniqueName, this.runtimeName, this.hash, this.start);
        if (!element.addDeployment(due)) {
            throw new UpdateFailedException("Deployment '" + this.uniqueName + "' is already configured");
        }
    }

    public DomainDeploymentRemove getCompensatingUpdate(DomainModel original) {
        return new DomainDeploymentRemove(this.uniqueName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

