/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainExtensionAdd;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class DomainExtensionRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 3718982114819320314L;
    private final String moduleName;

    public DomainExtensionRemove(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (!element.removeExtension(this.moduleName)) {
            throw new UpdateFailedException("Extension " + this.moduleName + " was not configured");
        }
    }

    public DomainExtensionAdd getCompensatingUpdate(DomainModel original) {
        if (original.getExtensions().contains(this.moduleName)) {
            return new DomainExtensionAdd(this.moduleName);
        }
        return null;
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

