/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainInterfaceAdd;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModelInterfaceRemove;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.model.socket.SocketBindingElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;

public class DomainInterfaceRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9182707456362234629L;
    private final String name;

    public DomainInterfaceRemove(String name) {
        this.name = name;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        StringBuilder illegal = null;
        for (String groupName : element.getSocketBindingGroupNames()) {
            SocketBindingGroupElement sbge = element.getSocketBindingGroup(groupName);
            boolean bad = false;
            if (this.name.equals(sbge.getDefaultInterface())) {
                bad = true;
            } else {
                for (SocketBindingElement sbe : sbge.getSocketBindings()) {
                    if (!this.name.equals(sbe.getInterfaceName())) continue;
                    bad = true;
                    break;
                }
            }
            if (!bad) continue;
            if (illegal == null) {
                illegal = new StringBuilder(groupName);
                continue;
            }
            illegal.append(", ");
            illegal.append(groupName);
        }
        if (illegal != null) {
            throw new UpdateFailedException(String.format("Interface %s cannot be removed as it is referenced by socket binding groups %s", this.name, illegal.toString()));
        }
        if (!element.removeInterface(this.name)) {
            throw new UpdateFailedException("failed to remove network interface " + this.name);
        }
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        InterfaceElement element = original.getInterface(this.name);
        if (element == null) {
            return null;
        }
        return new DomainInterfaceAdd(new InterfaceAdd(element));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerModelInterfaceRemove(this.name);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

