/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModel;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.Element;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class DomainModel
extends AbstractModel<DomainModel> {
    private static final long serialVersionUID = 5516070442013067881L;
    private final Set<String> extensions = new LinkedHashSet<String>();
    private final Map<String, ServerGroupElement> serverGroups = new LinkedHashMap<String, ServerGroupElement>();
    private final Map<String, DeploymentUnitElement> deployments = new LinkedHashMap<String, DeploymentUnitElement>();
    private final Map<String, ProfileElement> profiles = new LinkedHashMap<String, ProfileElement>();
    private final Map<String, PathElement> paths = new LinkedHashMap<String, PathElement>();
    private final Map<String, InterfaceElement> interfaces = new LinkedHashMap<String, InterfaceElement>();
    private final Map<String, SocketBindingGroupElement> bindingGroups = new LinkedHashMap<String, SocketBindingGroupElement>();
    private PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);
    private static final QName ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.DOMAIN.getLocalName());

    public DomainModel() {
        super(ELEMENT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getExtensions() {
        Set<String> set = this.extensions;
        synchronized (set) {
            return new HashSet<String>(this.extensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InterfaceElement> getInterfaces() {
        LinkedHashSet<InterfaceElement> intfs = new LinkedHashSet<InterfaceElement>();
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            for (Map.Entry<String, InterfaceElement> entry : this.interfaces.entrySet()) {
                intfs.add(entry.getValue());
            }
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceElement getInterface(String name) {
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            return this.interfaces.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileElement getProfile(String name) {
        Map<String, ProfileElement> map = this.profiles;
        synchronized (map) {
            return this.profiles.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ProfileElement> getProfiles(String name) {
        HashMap<String, ProfileElement> result = new HashMap<String, ProfileElement>();
        Map<String, ProfileElement> map = this.profiles;
        synchronized (map) {
            this.getProfiles(result, name);
        }
        return result;
    }

    private void getProfiles(Map<String, ProfileElement> profiles, String name) {
        if (profiles.containsKey(name)) {
            return;
        }
        ProfileElement pe = this.getProfile(name);
        if (pe == null) {
            throw new IllegalArgumentException("Profile " + name + " is unknown");
        }
        profiles.put(name, pe);
        for (String included : pe.getIncludedProfiles()) {
            this.getProfiles(profiles, included);
        }
    }

    public Collection<PathElement> getPaths() {
        return Collections.unmodifiableCollection(new HashSet<PathElement>(this.paths.values()));
    }

    public PathElement getPath(String name) {
        return this.paths.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSocketBindingGroupNames() {
        Map<String, SocketBindingGroupElement> map = this.bindingGroups;
        synchronized (map) {
            return new HashSet<String>(this.bindingGroups.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketBindingGroupElement getSocketBindingGroup(String name) {
        Map<String, SocketBindingGroupElement> map = this.bindingGroups;
        synchronized (map) {
            return this.bindingGroups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getServerGroupNames() {
        Map<String, ServerGroupElement> map = this.serverGroups;
        synchronized (map) {
            return new HashSet<String>(this.serverGroups.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGroupElement getServerGroup(String name) {
        Map<String, ServerGroupElement> map = this.serverGroups;
        synchronized (map) {
            return this.serverGroups.get(name);
        }
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentUnitElement getDeployment(String uniqueName) {
        Map<String, DeploymentUnitElement> map = this.deployments;
        synchronized (map) {
            return this.deployments.get(uniqueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDeploymentNames() {
        Map<String, DeploymentUnitElement> map = this.deployments;
        synchronized (map) {
            return new LinkedHashSet<String>(this.deployments.keySet());
        }
    }

    @Override
    protected Class<DomainModel> getElementClass() {
        return DomainModel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        this.writeNamespaces(streamWriter);
        if (!this.extensions.isEmpty()) {
            streamWriter.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String extension : this.extensions) {
                streamWriter.writeEmptyElement(Element.EXTENSION.getLocalName());
                streamWriter.writeAttribute(Attribute.MODULE.getLocalName(), extension);
            }
            streamWriter.writeEndElement();
        }
        Map<String, AbstractModelElement> map = this.paths;
        synchronized (map) {
            if (!this.paths.isEmpty()) {
                streamWriter.writeStartElement(Element.PATHS.getLocalName());
                for (PathElement pathElement : this.paths.values()) {
                    streamWriter.writeStartElement(Element.PATH.getLocalName());
                    pathElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        map = this.profiles;
        synchronized (map) {
            if (!this.profiles.isEmpty()) {
                streamWriter.writeStartElement(Element.PROFILES.getLocalName());
                for (ProfileElement profileElement : this.profiles.values()) {
                    streamWriter.writeStartElement(Element.PROFILE.getLocalName());
                    profileElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        map = this.interfaces;
        synchronized (map) {
            if (!this.interfaces.isEmpty()) {
                streamWriter.writeStartElement(Element.INTERFACES.getLocalName());
                for (InterfaceElement interfaceElement : this.interfaces.values()) {
                    streamWriter.writeStartElement(Element.INTERFACE.getLocalName());
                    interfaceElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        map = this.bindingGroups;
        synchronized (map) {
            if (!this.bindingGroups.isEmpty()) {
                streamWriter.writeStartElement(Element.SOCKET_BINDING_GROUPS.getLocalName());
                for (SocketBindingGroupElement socketBindingGroupElement : this.bindingGroups.values()) {
                    streamWriter.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
                    socketBindingGroupElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        map = this.deployments;
        synchronized (map) {
            if (!this.deployments.isEmpty()) {
                streamWriter.writeStartElement(Element.DEPLOYMENTS.getLocalName());
                for (DeploymentUnitElement deploymentUnitElement : this.deployments.values()) {
                    streamWriter.writeStartElement(Element.DEPLOYMENT.getLocalName());
                    deploymentUnitElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        map = this.serverGroups;
        synchronized (map) {
            if (!this.serverGroups.isEmpty()) {
                streamWriter.writeStartElement(Element.SERVER_GROUPS.getLocalName());
                for (ServerGroupElement serverGroupElement : this.serverGroups.values()) {
                    streamWriter.writeStartElement(Element.SERVER_GROUP.getLocalName());
                    serverGroupElement.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        streamWriter.writeEndElement();
    }

    boolean addExtension(String name) {
        return this.extensions.add(name);
    }

    boolean removeExtension(String name) {
        return this.extensions.remove(name);
    }

    boolean addProfile(String name) {
        if (this.profiles.containsKey(name)) {
            return false;
        }
        ProfileElement pe = new ProfileElement(name);
        this.profiles.put(name, pe);
        return true;
    }

    boolean removeProfile(String name) {
        ProfileElement pe = this.profiles.remove(name);
        return pe != null;
    }

    boolean addServerGroup(String name, String profile) {
        if (this.serverGroups.containsKey(name)) {
            return false;
        }
        ServerGroupElement group = new ServerGroupElement(name, profile);
        this.serverGroups.put(name, group);
        return true;
    }

    boolean removeServerGroup(String name) {
        return this.serverGroups.remove(name) != null;
    }

    SocketBindingGroupElement addSocketBindingGroup(String name) {
        if (this.bindingGroups.containsKey(name)) {
            return null;
        }
        SocketBindingGroupElement bindingGroup = new SocketBindingGroupElement(name);
        this.bindingGroups.put(name, bindingGroup);
        return bindingGroup;
    }

    boolean removeBindingGroup(String name) {
        return this.bindingGroups.remove(name) != null;
    }

    InterfaceElement addInterface(String name) {
        if (this.interfaces.containsKey(name)) {
            return null;
        }
        InterfaceElement networkInterface = new InterfaceElement(name);
        this.interfaces.put(name, networkInterface);
        return networkInterface;
    }

    boolean removeInterface(String name) {
        return this.interfaces.remove(name) != null;
    }

    boolean addDeployment(DeploymentUnitElement deployment) {
        if (this.deployments.containsKey(deployment.getUniqueName())) {
            return false;
        }
        this.deployments.put(deployment.getUniqueName(), deployment);
        return true;
    }

    boolean removeDeployment(String uniqueName) {
        return this.deployments.remove(uniqueName) != null;
    }

    Set<String> getServerGroupDeploymentsMappings(String deploymentUniqueName) {
        HashSet<String> mappings = new HashSet<String>();
        for (ServerGroupElement sge : this.serverGroups.values()) {
            if (sge.getDeployment(deploymentUniqueName) == null) continue;
            mappings.add(sge.getName());
        }
        return mappings;
    }

    PathElement addPath(String name) {
        if (this.paths.containsKey(name)) {
            return null;
        }
        PathElement element = new PathElement(name);
        this.paths.put(name, element);
        return element;
    }

    boolean removePath(String name) {
        return this.paths.remove(name) != null;
    }
}

