/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainPathRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.UpdateFailedException;

public class DomainPathAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 2651547614339664337L;
    private final PathElementUpdate update;

    public DomainPathAdd(PathElementUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("null path element update");
        }
        this.update = update;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        PathElement path = element.addPath(this.update.getName());
        if (path == null) {
            throw new UpdateFailedException("duplicate path " + this.update.getName());
        }
        this.update.applyUpdate(path);
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        return new DomainPathRemove(this.update.getName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathAdd(this.update);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        String pathName = this.update.getName();
        if (hostModel.getPath(pathName) != null) {
            return Collections.emptyList();
        }
        List<String> activeServers = hostModel.getActiveServerNames();
        Iterator<String> it = activeServers.iterator();
        while (it.hasNext()) {
            ServerElement server = hostModel.getServer(it.next());
            if (server.getPath(pathName) == null) continue;
            it.remove();
        }
        return activeServers;
    }
}

