/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainServerGroupAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;

public class DomainServerGroupRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -7482118547411879295L;
    private final String serverGroupName;

    public DomainServerGroupRemove(String serverGroupName) {
        this.serverGroupName = serverGroupName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (element.removeServerGroup(this.serverGroupName)) {
            throw new UpdateFailedException(String.format("server-group (%s) does not exist.", this.serverGroupName));
        }
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        ServerGroupElement group = original.getServerGroup(this.serverGroupName);
        return new DomainServerGroupAdd(group.getName(), group.getProfileName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        StringBuilder illegalServers = null;
        for (ServerElement server : hostModel.getServers()) {
            if (!this.serverGroupName.equals(server.getServerGroup())) continue;
            if (illegalServers == null) {
                illegalServers = new StringBuilder(server.getName());
                continue;
            }
            illegalServers.append(", ");
            illegalServers.append(server.getName());
        }
        if (illegalServers != null) {
            throw new UpdateFailedException(String.format("Cannot remove server group %s as it still has member servers %s", this.serverGroupName, illegalServers.toString()));
        }
        return Collections.emptyList();
    }
}

