/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;

public final class DomainServerGroupUpdate<R>
extends AbstractDomainModelUpdate<R> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String serverGroupName;
    private final AbstractModelUpdate<ServerGroupElement, R> serverGroupUpdate;

    public static <T> DomainServerGroupUpdate<T> create(String serverGroupName, AbstractModelUpdate<ServerGroupElement, T> update) {
        return new DomainServerGroupUpdate<T>(serverGroupName, update);
    }

    public DomainServerGroupUpdate(String serverGroupName, AbstractModelUpdate<ServerGroupElement, R> serverGroupUpdate) {
        this.serverGroupName = serverGroupName;
        this.serverGroupUpdate = serverGroupUpdate;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ServerGroupElement serverGroup = element.getServerGroup(this.serverGroupName);
        if (serverGroup == null) {
            throw new UpdateFailedException("Server group " + this.serverGroupName + " does not exist");
        }
        this.serverGroupUpdate.applyUpdate(serverGroup);
    }

    @Override
    public DomainServerGroupUpdate<?> getCompensatingUpdate(DomainModel original) {
        ServerGroupElement serverGroup = original.getServerGroup(this.serverGroupName);
        if (serverGroup == null) {
            return null;
        }
        return DomainServerGroupUpdate.create(this.serverGroupName, this.serverGroupUpdate.getCompensatingUpdate((AbstractModelElement)serverGroup));
    }

    @Override
    public AbstractServerModelUpdate<R> getServerModelUpdate() {
        return this.serverGroupUpdate.getServerModelUpdate();
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        if (this.getServerModelUpdate() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String server : hostModel.getActiveServerNames()) {
            if (!this.serverGroupName.equals(hostModel.getServer(server).getServerGroup())) continue;
            result.add(server);
        }
        return result;
    }
}

