/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostInterfaceRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModelInterfaceAdd;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;

public class HostInterfaceAdd
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 8657276301755318586L;
    private final InterfaceAdd delegate;

    public HostInterfaceAdd(InterfaceAdd add) {
        this.delegate = add;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        InterfaceElement networkInterface = element.addInterface(this.delegate.getName());
        if (networkInterface == null) {
            throw new UpdateFailedException("duplicate interface binding " + this.delegate.getName());
        }
        this.delegate.applyUpdate(networkInterface);
    }

    @Override
    public AbstractHostModelUpdate<?> getCompensatingUpdate(HostModel original) {
        return new HostInterfaceRemove(this.delegate.getName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerModelInterfaceAdd(this.delegate);
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return hostModel.getActiveServerNames();
    }
}

