/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostJvmRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class HostJvmAdd
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String jvmName;

    public HostJvmAdd(String jvmName) {
        this.jvmName = jvmName;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.addJvm(this.jvmName)) {
            throw new UpdateFailedException("JVM " + this.jvmName + " already configured");
        }
    }

    public HostJvmRemove getCompensatingUpdate(HostModel original) {
        if (original.getJvm(this.jvmName) != null) {
            return null;
        }
        return new HostJvmRemove(this.jvmName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

