/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.UpdateFailedException;

public final class HostManagementSocketThreadsUpdate
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final int maxThreads;

    public HostManagementSocketThreadsUpdate(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        ManagementElement me = element.getManagementElement();
        if (me == null) {
            throw new UpdateFailedException("No management socket configured");
        }
        me.setMaxThreads(this.maxThreads);
    }

    public HostManagementSocketThreadsUpdate getCompensatingUpdate(HostModel original) {
        ManagementElement me = original.getManagementElement();
        if (me == null) {
            return null;
        }
        return new HostManagementSocketThreadsUpdate(me.getMaxThreads());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

